/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.util.ArrayListWithHref;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.BackupContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlBackupPhaseReader;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskReader;
import org.ovirt.engine.sdk4.internal.xml.XmlHostReader;
import org.ovirt.engine.sdk4.internal.xml.XmlVmReader;
import org.ovirt.engine.sdk4.types.Backup;
import org.ovirt.engine.sdk4.types.Disk;

public class XmlBackupReader {
    public static Backup readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        BackupContainer object = new BackupContainer();
        block34: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block34;
                }
                case "id": {
                    object.id(image);
                    continue block34;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block35: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "comment": {
                    object.comment(reader.readString());
                    continue block35;
                }
                case "creation_date": {
                    object.creationDate(reader.readDate());
                    continue block35;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block35;
                }
                case "disks": {
                    object.disks(XmlDiskReader.readMany(reader));
                    continue block35;
                }
                case "from_checkpoint_id": {
                    object.fromCheckpointId(reader.readString());
                    continue block35;
                }
                case "host": {
                    object.host(XmlHostReader.readOne(reader));
                    continue block35;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block35;
                }
                case "phase": {
                    object.phase(XmlBackupPhaseReader.readOne(reader));
                    continue block35;
                }
                case "to_checkpoint_id": {
                    object.toCheckpointId(reader.readString());
                    continue block35;
                }
                case "vm": {
                    object.vm(XmlVmReader.readOne(reader));
                    continue block35;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.skip();
                    continue block35;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlBackupReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<Backup> iterateMany(final XmlReader reader) {
        return new Iterator<Backup>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public Backup next() {
                Backup next = XmlBackupReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<Backup> readMany(XmlReader reader) {
        ArrayList<Backup> list = new ArrayList<Backup>();
        Iterator<Backup> iterator = XmlBackupReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(BackupContainer object, String[] link) {
        String rel = link[0];
        String href = link[1];
        if (href != null) {
            switch (rel) {
                case "disks": {
                    ArrayListWithHref<Disk> list = new ArrayListWithHref<Disk>(object.disks());
                    list.href(href);
                    object.disks(list);
                    break;
                }
            }
        }
    }
}

