/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum StepEnum {
    EXECUTING("executing"),
    FINALIZING("finalizing"),
    REBALANCING_VOLUME("rebalancing_volume"),
    REMOVING_BRICKS("removing_bricks"),
    UNKNOWN("unknown"),
    VALIDATING("validating");

    private static final Logger log;
    private String image;

    private StepEnum(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static StepEnum fromValue(String value) {
        try {
            return StepEnum.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'StepEnum' enumerated type. Valid values are 'executing', 'finalizing', 'rebalancing_volume', 'removing_bricks', 'unknown' and 'validating'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(StepEnum.class);
    }
}

