/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.ExternalHostProviderBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ExternalHostProviderServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlExternalHostProviderReader;
import org.ovirt.engine.sdk4.internal.xml.XmlExternalHostProviderWriter;
import org.ovirt.engine.sdk4.services.ExternalHostProviderService;
import org.ovirt.engine.sdk4.services.ExternalHostProvidersService;
import org.ovirt.engine.sdk4.types.ExternalHostProvider;

public class ExternalHostProvidersServiceImpl
extends ServiceImpl
implements ExternalHostProvidersService {
    public ExternalHostProvidersServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public ExternalHostProvidersService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public ExternalHostProvidersService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public ExternalHostProviderService providerService(String id) {
        return new ExternalHostProviderServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.providerService(path);
        }
        return this.providerService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "ExternalHostProvidersService:" + this.getPath();
    }

    private class ListResponseImpl
    implements ExternalHostProvidersService.ListResponse {
        private List<ExternalHostProvider> providers;

        private ListResponseImpl() {
        }

        public void providers(List<ExternalHostProvider> providers) {
            this.providers = providers;
        }

        @Override
        public List<ExternalHostProvider> providers() {
            return this.providers;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<ExternalHostProvidersService.ListRequest, ExternalHostProvidersService.ListResponse>
    implements ExternalHostProvidersService.ListRequest {
        private String follow;
        private BigInteger max;
        private String search;

        private ListRequestImpl() {
        }

        @Override
        public ExternalHostProvidersService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public ExternalHostProvidersService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public ExternalHostProvidersService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public ExternalHostProvidersService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public ExternalHostProvidersService.ListRequest search(String search) {
            this.search = search;
            return this;
        }

        @Override
        public ExternalHostProvidersService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(ExternalHostProvidersServiceImpl.this.getConnection().getUrl() + ExternalHostProvidersServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.search != null) {
                    uriBuilder.addParameter("search", XmlWriter.renderString(this.search));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = ExternalHostProvidersServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.providers(XmlExternalHostProviderReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            ExternalHostProvidersServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements ExternalHostProvidersService.AddResponse {
        private ExternalHostProvider provider;

        private AddResponseImpl() {
        }

        public void provider(ExternalHostProvider provider) {
            this.provider = provider;
        }

        @Override
        public ExternalHostProvider provider() {
            return this.provider;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<ExternalHostProvidersService.AddRequest, ExternalHostProvidersService.AddResponse>
    implements ExternalHostProvidersService.AddRequest {
        private ExternalHostProvider provider;

        private AddRequestImpl() {
        }

        @Override
        public ExternalHostProvidersService.AddRequest provider(ExternalHostProvider provider) {
            this.provider = provider;
            return this;
        }

        @Override
        public ExternalHostProvidersService.AddRequest provider(ExternalHostProviderBuilder provider) {
            this.provider = provider.build();
            return this;
        }

        @Override
        public ExternalHostProvidersService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(ExternalHostProvidersServiceImpl.this.getConnection().getUrl() + ExternalHostProvidersServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlExternalHostProviderWriter.writeOne(this.provider, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = ExternalHostProvidersServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.provider(XmlExternalHostProviderReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            ExternalHostProvidersServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

