/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.QuotaBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.QuotaServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlQuotaReader;
import org.ovirt.engine.sdk4.internal.xml.XmlQuotaWriter;
import org.ovirt.engine.sdk4.services.QuotaService;
import org.ovirt.engine.sdk4.services.QuotasService;
import org.ovirt.engine.sdk4.types.Quota;

public class QuotasServiceImpl
extends ServiceImpl
implements QuotasService {
    public QuotasServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public QuotasService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public QuotasService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public QuotaService quotaService(String id) {
        return new QuotaServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.quotaService(path);
        }
        return this.quotaService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "QuotasService:" + this.getPath();
    }

    private class ListResponseImpl
    implements QuotasService.ListResponse {
        private List<Quota> quotas;

        private ListResponseImpl() {
        }

        public void quotas(List<Quota> quotas) {
            this.quotas = quotas;
        }

        @Override
        public List<Quota> quotas() {
            return this.quotas;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<QuotasService.ListRequest, QuotasService.ListResponse>
    implements QuotasService.ListRequest {
        private String follow;
        private BigInteger max;

        private ListRequestImpl() {
        }

        @Override
        public QuotasService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public QuotasService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public QuotasService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public QuotasService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public QuotasService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(QuotasServiceImpl.this.getConnection().getUrl() + QuotasServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = QuotasServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.quotas(XmlQuotaReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            QuotasServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements QuotasService.AddResponse {
        private Quota quota;

        private AddResponseImpl() {
        }

        public void quota(Quota quota) {
            this.quota = quota;
        }

        @Override
        public Quota quota() {
            return this.quota;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<QuotasService.AddRequest, QuotasService.AddResponse>
    implements QuotasService.AddRequest {
        private Quota quota;

        private AddRequestImpl() {
        }

        @Override
        public QuotasService.AddRequest quota(Quota quota) {
            this.quota = quota;
            return this;
        }

        @Override
        public QuotasService.AddRequest quota(QuotaBuilder quota) {
            this.quota = quota.build();
            return this;
        }

        @Override
        public QuotasService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(QuotasServiceImpl.this.getConnection().getUrl() + QuotasServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlQuotaWriter.writeOne(this.quota, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = QuotasServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.quota(XmlQuotaReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            QuotasServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

