/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.services;

import java.io.IOException;
import org.ovirt.engine.sdk4.Request;
import org.ovirt.engine.sdk4.Response;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.UserOptionBuilder;
import org.ovirt.engine.sdk4.types.UserOption;

public interface UserOptionService extends Service {
    /**
     * Returns a user profile property of type JSON.
     * 
     * Example request(for user with identifier `123` and option with identifier `456`):
     * 
     * [source]
     * ----
     * GET /ovirt-engine/api/users/123/options/456
     * ----
     * 
     * The result will be the following XML document:
     * 
     * [source,xml]
     * ----
     *   <user_option href="/ovirt-engine/api/users/123/options/456" id="456">
     *     <name>SomeName</name>
     *     <content>["any", "JSON"]</content>
     *     <user href="/ovirt-engine/api/users/123" id="123"/>
     *   </user_option>
     * ----
     */
    public interface GetRequest extends Request<GetRequest, GetResponse> {
    }
    
    /**
     * Returns a user profile property of type JSON.
     * 
     * Example request(for user with identifier `123` and option with identifier `456`):
     * 
     * [source]
     * ----
     * GET /ovirt-engine/api/users/123/options/456
     * ----
     * 
     * The result will be the following XML document:
     * 
     * [source,xml]
     * ----
     *   <user_option href="/ovirt-engine/api/users/123/options/456" id="456">
     *     <name>SomeName</name>
     *     <content>["any", "JSON"]</content>
     *     <user href="/ovirt-engine/api/users/123" id="123"/>
     *   </user_option>
     * ----
     */
    public interface GetResponse extends Response {
        UserOption option();
    }
    
    /**
     * Returns a user profile property of type JSON.
     * 
     * Example request(for user with identifier `123` and option with identifier `456`):
     * 
     * [source]
     * ----
     * GET /ovirt-engine/api/users/123/options/456
     * ----
     * 
     * The result will be the following XML document:
     * 
     * [source,xml]
     * ----
     *   <user_option href="/ovirt-engine/api/users/123/options/456" id="456">
     *     <name>SomeName</name>
     *     <content>["any", "JSON"]</content>
     *     <user href="/ovirt-engine/api/users/123" id="123"/>
     *   </user_option>
     * ----
     */
    GetRequest get();
    
    /**
     * Deletes an existing property of type JSON.
     * 
     * Example request(for user with identifier `123` and option with identifier `456`):
     * 
     * [source]
     * ----
     * DELETE /ovirt-engine/api/users/123/options/456
     * ----
     */
    public interface RemoveRequest extends Request<RemoveRequest, RemoveResponse> {
    }
    
    /**
     * Deletes an existing property of type JSON.
     * 
     * Example request(for user with identifier `123` and option with identifier `456`):
     * 
     * [source]
     * ----
     * DELETE /ovirt-engine/api/users/123/options/456
     * ----
     */
    public interface RemoveResponse extends Response {
    }
    
    /**
     * Deletes an existing property of type JSON.
     * 
     * Example request(for user with identifier `123` and option with identifier `456`):
     * 
     * [source]
     * ----
     * DELETE /ovirt-engine/api/users/123/options/456
     * ----
     */
    RemoveRequest remove();
    
    /**
     * Replaces an existing property of type JSON with a new one.
     * 
     * Example request(for user with identifier `123` and option with identifier `456`):
     * 
     * [source]
     * ----
     * PUT /ovirt-engine/api/users/123/options/456
     * ----
     * 
     * Payload:
     * 
     * [source,xml]
     * ----
     * <user_option>
     *   <name>SomeName</name>
     *   <content>{"new" : "JSON"}</content>
     * </user_option>
     * ----
     * 
     * The result will be the following XML document:
     * 
     * [source,xml]
     * ----
     * <user_option href="/ovirt-engine/api/users/123/options/789" id="789">
     *   <name>SomeName</name>
     *   <content>{"new" : "JSON"}</content>
     *   <user href="/ovirt-engine/api/users/123" id="123"/>
     * </user_option>
     * ----
     */
    public interface UpdateRequest extends Request<UpdateRequest, UpdateResponse> {
        UpdateRequest option(UserOption option);
        UpdateRequest option(UserOptionBuilder option);
    }
    
    /**
     * Replaces an existing property of type JSON with a new one.
     * 
     * Example request(for user with identifier `123` and option with identifier `456`):
     * 
     * [source]
     * ----
     * PUT /ovirt-engine/api/users/123/options/456
     * ----
     * 
     * Payload:
     * 
     * [source,xml]
     * ----
     * <user_option>
     *   <name>SomeName</name>
     *   <content>{"new" : "JSON"}</content>
     * </user_option>
     * ----
     * 
     * The result will be the following XML document:
     * 
     * [source,xml]
     * ----
     * <user_option href="/ovirt-engine/api/users/123/options/789" id="789">
     *   <name>SomeName</name>
     *   <content>{"new" : "JSON"}</content>
     *   <user href="/ovirt-engine/api/users/123" id="123"/>
     * </user_option>
     * ----
     */
    public interface UpdateResponse extends Response {
        UserOption option();
    }
    
    /**
     * Replaces an existing property of type JSON with a new one.
     * 
     * Example request(for user with identifier `123` and option with identifier `456`):
     * 
     * [source]
     * ----
     * PUT /ovirt-engine/api/users/123/options/456
     * ----
     * 
     * Payload:
     * 
     * [source,xml]
     * ----
     * <user_option>
     *   <name>SomeName</name>
     *   <content>{"new" : "JSON"}</content>
     * </user_option>
     * ----
     * 
     * The result will be the following XML document:
     * 
     * [source,xml]
     * ----
     * <user_option href="/ovirt-engine/api/users/123/options/789" id="789">
     *   <name>SomeName</name>
     *   <content>{"new" : "JSON"}</content>
     *   <user href="/ovirt-engine/api/users/123" id="123"/>
     * </user_option>
     * ----
     */
    UpdateRequest update();
    
    /**
     * Service locator method, returns individual service on which the URI is dispatched.
     */
    Service service(String path);
}

