/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.types;

import java.lang.String;
import java.math.BigInteger;

/**
 * This type contains information regarding an image transfer being performed.
 */
public interface ImageTransfer extends Identified {
    boolean active();
    
    boolean activePresent();
    
    ImageTransferDirection direction();
    
    boolean directionPresent();
    
    DiskFormat format();
    
    boolean formatPresent();
    
    BigInteger inactivityTimeout();
    Byte inactivityTimeoutAsByte();
    Short inactivityTimeoutAsShort();
    Integer inactivityTimeoutAsInteger();
    Long inactivityTimeoutAsLong();
    
    boolean inactivityTimeoutPresent();
    
    ImageTransferPhase phase();
    
    boolean phasePresent();
    
    String proxyUrl();
    
    boolean proxyUrlPresent();
    
    boolean shallow();
    
    boolean shallowPresent();
    
    ImageTransferTimeoutPolicy timeoutPolicy();
    
    boolean timeoutPolicyPresent();
    
    String transferUrl();
    
    boolean transferUrlPresent();
    
    BigInteger transferred();
    Byte transferredAsByte();
    Short transferredAsShort();
    Integer transferredAsInteger();
    Long transferredAsLong();
    
    boolean transferredPresent();
    
    Backup backup();
    
    boolean backupPresent();
    
    Disk disk();
    
    boolean diskPresent();
    
    Host host();
    
    boolean hostPresent();
    
    Image image();
    
    boolean imagePresent();
    
    DiskSnapshot snapshot();
    
    boolean snapshotPresent();
    
}
