/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.ovirt.engine.sdk4.Connection;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.HttpClient;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.NoCaTrustManager;

public abstract class ConnectionBuilder {
    protected static final String BAD_PROTOCOL_ERROR = "Unsupported protocol ";
    protected static final String BAD_KEY_ERROR = "SSL context initiation has failed because of key error.";
    protected static final String NO_TLS_ERROR = "SSL context initiation has failed locating TLS algorithm.";
    protected static final String KEY_STORE_ERROR = "CA certificate keystore initiation has failed.";
    protected static final String KEY_STORE_FILE_NOT_FOUND_ERROR = "CA certificate keystore was not found.";
    protected static final String CERTIFICATE_ERROR = "CA certificate error.";
    protected static final String IO_ERROR = "I/O error occurred, is your keystore password correct?";
    protected static String HTTP_PROTOCOL = "http";
    protected static String HTTPS_PROTOCOL = "https";
    protected String url;
    protected String user;
    protected String password;
    protected String token;
    protected boolean insecure = false;
    protected boolean kerberos = false;
    protected int timeout = 0;
    protected boolean compress = true;
    protected Map<String, String> headers = new HashMap<String, String>();
    protected String trustStoreFile;
    protected URL urlobj;
    protected String trustStorePassword;
    protected NoCaTrustManager noCaTrustManager = new NoCaTrustManager();
    private String ssoUrl;
    private String ssoRevokeUrl;
    private String ssoTokenName = "access_token";

    public static ConnectionBuilder connection() {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.ovirt.engine.sdk4.internal.ConnectionBuilder45");
        }
        catch (Throwable ex) {
            try {
                clazz = Class.forName("org.ovirt.engine.sdk4.internal.ConnectionBuilder42");
            }
            catch (Throwable e) {
                throw new Error("No connection implementation found", e);
            }
        }
        try {
            return (ConnectionBuilder)clazz.newInstance();
        }
        catch (Exception e) {
            throw new Error("Failed to initialize connection implementation", e);
        }
    }

    public ConnectionBuilder url(String url) {
        this.url = url;
        return this;
    }

    public ConnectionBuilder user(String user) {
        this.user = user;
        return this;
    }

    public ConnectionBuilder password(String password) {
        this.password = password;
        return this;
    }

    public ConnectionBuilder token(String token) {
        this.token = token;
        return this;
    }

    public ConnectionBuilder insecure(boolean insecure) {
        this.insecure = insecure;
        return this;
    }

    public ConnectionBuilder kerberos(boolean kerberos) {
        this.kerberos = kerberos;
        return this;
    }

    public ConnectionBuilder timeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public ConnectionBuilder compress(boolean compress) {
        this.compress = compress;
        return this;
    }

    public ConnectionBuilder trustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
        return this;
    }

    public ConnectionBuilder trustStoreFile(String trustStoreFile) {
        this.trustStoreFile = trustStoreFile;
        return this;
    }

    public ConnectionBuilder ssoUrl(String ssoUrl) {
        this.ssoUrl = ssoUrl;
        return this;
    }

    public ConnectionBuilder ssoRevokeUrl(String ssoRevokeUrl) {
        this.ssoRevokeUrl = ssoRevokeUrl;
        return this;
    }

    public ConnectionBuilder ssoTokenName(String ssoTokenName) {
        this.ssoTokenName = ssoTokenName;
        return this;
    }

    public ConnectionBuilder header(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public Connection build() {
        try {
            if (this.url == null) {
                throw new IllegalArgumentException("The 'url' parameter is mandatory");
            }
            if (this.trustStoreFile != null && !new File(this.trustStoreFile).exists()) {
                throw new IllegalArgumentException(String.format("The truststore file '%s' doesn't exist'", this.trustStoreFile));
            }
            this.urlobj = new URL(this.url);
            HttpConnection connection = new HttpConnection();
            connection.setClient(this.createHttpClient());
            connection.setUrl(this.url);
            connection.setUser(this.user);
            connection.setPassword(this.password);
            connection.setSsoToken(this.token);
            connection.setKerberos(this.kerberos);
            connection.setSsoUrl(this.ssoUrl);
            connection.setSsoTokenName(this.ssoTokenName);
            connection.setSsoRevokeUrl(this.ssoRevokeUrl);
            connection.setHeaders(this.headers);
            return connection;
        }
        catch (Exception e) {
            throw new Error("Failed to build connection", e);
        }
    }

    protected abstract HttpClient createHttpClient();

    protected String getHost() {
        return this.urlobj.getHost();
    }

    protected String getProtocol() {
        return this.urlobj.getProtocol();
    }

    protected int getPort() {
        return this.urlobj.getPort() == -1 ? this.urlobj.getDefaultPort() : this.urlobj.getPort();
    }

    public String getUrl() {
        return this.url.toString();
    }
}

