/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.AffinityLabelBuilder;
import org.ovirt.engine.sdk4.builders.AffinityRuleBuilder;
import org.ovirt.engine.sdk4.builders.ClusterBuilder;
import org.ovirt.engine.sdk4.builders.HostBuilder;
import org.ovirt.engine.sdk4.builders.VmBuilder;
import org.ovirt.engine.sdk4.internal.containers.AffinityGroupContainer;
import org.ovirt.engine.sdk4.types.AffinityGroup;
import org.ovirt.engine.sdk4.types.AffinityLabel;
import org.ovirt.engine.sdk4.types.AffinityRule;
import org.ovirt.engine.sdk4.types.Cluster;
import org.ovirt.engine.sdk4.types.Host;
import org.ovirt.engine.sdk4.types.Vm;

public class AffinityGroupBuilder {
    private Boolean broken;
    private Cluster cluster;
    private String comment;
    private String description;
    private Boolean enforcing;
    private List<AffinityLabel> hostLabels;
    private List<Host> hosts;
    private AffinityRule hostsRule;
    private String href;
    private String id;
    private String name;
    private Boolean positive;
    private BigDecimal priority;
    private List<AffinityLabel> vmLabels;
    private List<Vm> vms;
    private AffinityRule vmsRule;

    public AffinityGroupBuilder broken(boolean newBroken) {
        this.broken = newBroken;
        return this;
    }

    public AffinityGroupBuilder broken(Boolean newBroken) {
        this.broken = newBroken;
        return this;
    }

    public AffinityGroupBuilder cluster(Cluster newCluster) {
        this.cluster = newCluster;
        return this;
    }

    public AffinityGroupBuilder cluster(ClusterBuilder newCluster) {
        this.cluster = newCluster == null ? null : newCluster.build();
        return this;
    }

    public AffinityGroupBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public AffinityGroupBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public AffinityGroupBuilder enforcing(boolean newEnforcing) {
        this.enforcing = newEnforcing;
        return this;
    }

    public AffinityGroupBuilder enforcing(Boolean newEnforcing) {
        this.enforcing = newEnforcing;
        return this;
    }

    public AffinityGroupBuilder hostLabels(List<AffinityLabel> newHostLabels) {
        if (newHostLabels != null) {
            if (this.hostLabels == null) {
                this.hostLabels = new ArrayList<AffinityLabel>(newHostLabels);
            } else {
                this.hostLabels.addAll(newHostLabels);
            }
        }
        return this;
    }

    public AffinityGroupBuilder hostLabels(AffinityLabel ... newHostLabels) {
        if (newHostLabels != null) {
            if (this.hostLabels == null) {
                this.hostLabels = new ArrayList<AffinityLabel>(newHostLabels.length);
            }
            Collections.addAll(this.hostLabels, newHostLabels);
        }
        return this;
    }

    public AffinityGroupBuilder hostLabels(AffinityLabelBuilder ... newHostLabels) {
        if (newHostLabels != null) {
            if (this.hostLabels == null) {
                this.hostLabels = new ArrayList<AffinityLabel>(newHostLabels.length);
            }
            for (AffinityLabelBuilder builder : newHostLabels) {
                this.hostLabels.add(builder.build());
            }
        }
        return this;
    }

    public AffinityGroupBuilder hosts(List<Host> newHosts) {
        if (newHosts != null) {
            if (this.hosts == null) {
                this.hosts = new ArrayList<Host>(newHosts);
            } else {
                this.hosts.addAll(newHosts);
            }
        }
        return this;
    }

    public AffinityGroupBuilder hosts(Host ... newHosts) {
        if (newHosts != null) {
            if (this.hosts == null) {
                this.hosts = new ArrayList<Host>(newHosts.length);
            }
            Collections.addAll(this.hosts, newHosts);
        }
        return this;
    }

    public AffinityGroupBuilder hosts(HostBuilder ... newHosts) {
        if (newHosts != null) {
            if (this.hosts == null) {
                this.hosts = new ArrayList<Host>(newHosts.length);
            }
            for (HostBuilder builder : newHosts) {
                this.hosts.add(builder.build());
            }
        }
        return this;
    }

    public AffinityGroupBuilder hostsRule(AffinityRule newHostsRule) {
        this.hostsRule = newHostsRule;
        return this;
    }

    public AffinityGroupBuilder hostsRule(AffinityRuleBuilder newHostsRule) {
        this.hostsRule = newHostsRule == null ? null : newHostsRule.build();
        return this;
    }

    public AffinityGroupBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public AffinityGroupBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public AffinityGroupBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public AffinityGroupBuilder positive(boolean newPositive) {
        this.positive = newPositive;
        return this;
    }

    public AffinityGroupBuilder positive(Boolean newPositive) {
        this.positive = newPositive;
        return this;
    }

    public AffinityGroupBuilder priority(float newPriority) {
        this.priority = BigDecimal.valueOf(newPriority);
        return this;
    }

    public AffinityGroupBuilder priority(Float newPriority) {
        this.priority = newPriority == null ? null : BigDecimal.valueOf(newPriority.doubleValue());
        return this;
    }

    public AffinityGroupBuilder priority(double newPriority) {
        this.priority = BigDecimal.valueOf(newPriority);
        return this;
    }

    public AffinityGroupBuilder priority(Double newPriority) {
        this.priority = newPriority == null ? null : BigDecimal.valueOf(newPriority);
        return this;
    }

    public AffinityGroupBuilder priority(BigDecimal newPriority) {
        this.priority = newPriority;
        return this;
    }

    public AffinityGroupBuilder vmLabels(List<AffinityLabel> newVmLabels) {
        if (newVmLabels != null) {
            if (this.vmLabels == null) {
                this.vmLabels = new ArrayList<AffinityLabel>(newVmLabels);
            } else {
                this.vmLabels.addAll(newVmLabels);
            }
        }
        return this;
    }

    public AffinityGroupBuilder vmLabels(AffinityLabel ... newVmLabels) {
        if (newVmLabels != null) {
            if (this.vmLabels == null) {
                this.vmLabels = new ArrayList<AffinityLabel>(newVmLabels.length);
            }
            Collections.addAll(this.vmLabels, newVmLabels);
        }
        return this;
    }

    public AffinityGroupBuilder vmLabels(AffinityLabelBuilder ... newVmLabels) {
        if (newVmLabels != null) {
            if (this.vmLabels == null) {
                this.vmLabels = new ArrayList<AffinityLabel>(newVmLabels.length);
            }
            for (AffinityLabelBuilder builder : newVmLabels) {
                this.vmLabels.add(builder.build());
            }
        }
        return this;
    }

    public AffinityGroupBuilder vms(List<Vm> newVms) {
        if (newVms != null) {
            if (this.vms == null) {
                this.vms = new ArrayList<Vm>(newVms);
            } else {
                this.vms.addAll(newVms);
            }
        }
        return this;
    }

    public AffinityGroupBuilder vms(Vm ... newVms) {
        if (newVms != null) {
            if (this.vms == null) {
                this.vms = new ArrayList<Vm>(newVms.length);
            }
            Collections.addAll(this.vms, newVms);
        }
        return this;
    }

    public AffinityGroupBuilder vms(VmBuilder ... newVms) {
        if (newVms != null) {
            if (this.vms == null) {
                this.vms = new ArrayList<Vm>(newVms.length);
            }
            for (VmBuilder builder : newVms) {
                this.vms.add(builder.build());
            }
        }
        return this;
    }

    public AffinityGroupBuilder vmsRule(AffinityRule newVmsRule) {
        this.vmsRule = newVmsRule;
        return this;
    }

    public AffinityGroupBuilder vmsRule(AffinityRuleBuilder newVmsRule) {
        this.vmsRule = newVmsRule == null ? null : newVmsRule.build();
        return this;
    }

    public AffinityGroup build() {
        AffinityGroupContainer container = new AffinityGroupContainer();
        container.broken(this.broken);
        container.cluster(this.cluster);
        container.comment(this.comment);
        container.description(this.description);
        container.enforcing(this.enforcing);
        container.hostLabels(this.hostLabels);
        container.hosts(this.hosts);
        container.hostsRule(this.hostsRule);
        container.href(this.href);
        container.id(this.id);
        container.name(this.name);
        container.positive(this.positive);
        container.priority(this.priority);
        container.vmLabels(this.vmLabels);
        container.vms(this.vms);
        container.vmsRule(this.vmsRule);
        return container;
    }
}

