/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.ovirt.engine.sdk4.builders.DiskBuilder;
import org.ovirt.engine.sdk4.builders.HostBuilder;
import org.ovirt.engine.sdk4.builders.VmBuilder;
import org.ovirt.engine.sdk4.internal.containers.BackupContainer;
import org.ovirt.engine.sdk4.types.Backup;
import org.ovirt.engine.sdk4.types.BackupPhase;
import org.ovirt.engine.sdk4.types.Disk;
import org.ovirt.engine.sdk4.types.Host;
import org.ovirt.engine.sdk4.types.Vm;

public class BackupBuilder {
    private String comment;
    private Date creationDate;
    private String description;
    private List<Disk> disks;
    private String fromCheckpointId;
    private Host host;
    private String href;
    private String id;
    private Date modificationDate;
    private String name;
    private BackupPhase phase;
    private String toCheckpointId;
    private Vm vm;

    public BackupBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public BackupBuilder creationDate(Date newCreationDate) {
        this.creationDate = newCreationDate == null ? null : new Date(newCreationDate.getTime());
        return this;
    }

    public BackupBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public BackupBuilder disks(List<Disk> newDisks) {
        if (newDisks != null) {
            if (this.disks == null) {
                this.disks = new ArrayList<Disk>(newDisks);
            } else {
                this.disks.addAll(newDisks);
            }
        }
        return this;
    }

    public BackupBuilder disks(Disk ... newDisks) {
        if (newDisks != null) {
            if (this.disks == null) {
                this.disks = new ArrayList<Disk>(newDisks.length);
            }
            Collections.addAll(this.disks, newDisks);
        }
        return this;
    }

    public BackupBuilder disks(DiskBuilder ... newDisks) {
        if (newDisks != null) {
            if (this.disks == null) {
                this.disks = new ArrayList<Disk>(newDisks.length);
            }
            for (DiskBuilder builder : newDisks) {
                this.disks.add(builder.build());
            }
        }
        return this;
    }

    public BackupBuilder fromCheckpointId(String newFromCheckpointId) {
        this.fromCheckpointId = newFromCheckpointId;
        return this;
    }

    public BackupBuilder host(Host newHost) {
        this.host = newHost;
        return this;
    }

    public BackupBuilder host(HostBuilder newHost) {
        this.host = newHost == null ? null : newHost.build();
        return this;
    }

    public BackupBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public BackupBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public BackupBuilder modificationDate(Date newModificationDate) {
        this.modificationDate = newModificationDate == null ? null : new Date(newModificationDate.getTime());
        return this;
    }

    public BackupBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public BackupBuilder phase(BackupPhase newPhase) {
        this.phase = newPhase;
        return this;
    }

    public BackupBuilder toCheckpointId(String newToCheckpointId) {
        this.toCheckpointId = newToCheckpointId;
        return this;
    }

    public BackupBuilder vm(Vm newVm) {
        this.vm = newVm;
        return this;
    }

    public BackupBuilder vm(VmBuilder newVm) {
        this.vm = newVm == null ? null : newVm.build();
        return this;
    }

    public Backup build() {
        BackupContainer container = new BackupContainer();
        container.comment(this.comment);
        container.creationDate(this.creationDate);
        container.description(this.description);
        container.disks(this.disks);
        container.fromCheckpointId(this.fromCheckpointId);
        container.host(this.host);
        container.href(this.href);
        container.id(this.id);
        container.modificationDate(this.modificationDate);
        container.name(this.name);
        container.phase(this.phase);
        container.toCheckpointId(this.toCheckpointId);
        container.vm(this.vm);
        return container;
    }
}

