/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.ExternalVmImportBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlExternalVmImportReader;
import org.ovirt.engine.sdk4.internal.xml.XmlExternalVmImportWriter;
import org.ovirt.engine.sdk4.services.ExternalVmImportsService;
import org.ovirt.engine.sdk4.types.ExternalVmImport;

public class ExternalVmImportsServiceImpl
extends ServiceImpl
implements ExternalVmImportsService {
    public ExternalVmImportsServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public ExternalVmImportsService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "ExternalVmImportsService:" + this.getPath();
    }

    private class AddResponseImpl
    implements ExternalVmImportsService.AddResponse {
        private ExternalVmImport import_;

        private AddResponseImpl() {
        }

        public void import_(ExternalVmImport import_) {
            this.import_ = import_;
        }

        @Override
        public ExternalVmImport import_() {
            return this.import_;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<ExternalVmImportsService.AddRequest, ExternalVmImportsService.AddResponse>
    implements ExternalVmImportsService.AddRequest {
        private ExternalVmImport import_;

        private AddRequestImpl() {
        }

        @Override
        public ExternalVmImportsService.AddRequest import_(ExternalVmImport import_) {
            this.import_ = import_;
            return this;
        }

        @Override
        public ExternalVmImportsService.AddRequest import_(ExternalVmImportBuilder import_) {
            this.import_ = import_.build();
            return this;
        }

        @Override
        public ExternalVmImportsService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(ExternalVmImportsServiceImpl.this.getConnection().getUrl() + ExternalVmImportsServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlExternalVmImportWriter.writeOne(this.import_, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = ExternalVmImportsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.import_(XmlExternalVmImportReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            ExternalVmImportsServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

