/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.AgentBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.FenceAgentServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlAgentReader;
import org.ovirt.engine.sdk4.internal.xml.XmlAgentWriter;
import org.ovirt.engine.sdk4.services.FenceAgentService;
import org.ovirt.engine.sdk4.services.FenceAgentsService;
import org.ovirt.engine.sdk4.types.Agent;

public class FenceAgentsServiceImpl
extends ServiceImpl
implements FenceAgentsService {
    public FenceAgentsServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public FenceAgentsService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public FenceAgentsService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public FenceAgentService agentService(String id) {
        return new FenceAgentServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.agentService(path);
        }
        return this.agentService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "FenceAgentsService:" + this.getPath();
    }

    private class ListResponseImpl
    implements FenceAgentsService.ListResponse {
        private List<Agent> agents;

        private ListResponseImpl() {
        }

        public void agents(List<Agent> agents) {
            this.agents = agents;
        }

        @Override
        public List<Agent> agents() {
            return this.agents;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<FenceAgentsService.ListRequest, FenceAgentsService.ListResponse>
    implements FenceAgentsService.ListRequest {
        private String follow;
        private BigInteger max;

        private ListRequestImpl() {
        }

        @Override
        public FenceAgentsService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public FenceAgentsService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public FenceAgentsService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public FenceAgentsService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public FenceAgentsService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(FenceAgentsServiceImpl.this.getConnection().getUrl() + FenceAgentsServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = FenceAgentsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.agents(XmlAgentReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            FenceAgentsServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements FenceAgentsService.AddResponse {
        private Agent agent;

        private AddResponseImpl() {
        }

        public void agent(Agent agent) {
            this.agent = agent;
        }

        @Override
        public Agent agent() {
            return this.agent;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<FenceAgentsService.AddRequest, FenceAgentsService.AddResponse>
    implements FenceAgentsService.AddRequest {
        private Agent agent;

        private AddRequestImpl() {
        }

        @Override
        public FenceAgentsService.AddRequest agent(Agent agent) {
            this.agent = agent;
            return this;
        }

        @Override
        public FenceAgentsService.AddRequest agent(AgentBuilder agent) {
            this.agent = agent.build();
            return this;
        }

        @Override
        public FenceAgentsService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(FenceAgentsServiceImpl.this.getConnection().getUrl() + FenceAgentsServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlAgentWriter.writeOne(this.agent, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = FenceAgentsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.agent(XmlAgentReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            FenceAgentsServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

