/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.OpenStackVolumeProviderBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ExternalProviderCertificatesServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ExternalProviderServiceImpl;
import org.ovirt.engine.sdk4.internal.services.OpenstackVolumeAuthenticationKeysServiceImpl;
import org.ovirt.engine.sdk4.internal.services.OpenstackVolumeTypesServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlOpenStackVolumeProviderReader;
import org.ovirt.engine.sdk4.internal.xml.XmlOpenStackVolumeProviderWriter;
import org.ovirt.engine.sdk4.services.ExternalProviderCertificatesService;
import org.ovirt.engine.sdk4.services.OpenstackVolumeAuthenticationKeysService;
import org.ovirt.engine.sdk4.services.OpenstackVolumeProviderService;
import org.ovirt.engine.sdk4.services.OpenstackVolumeTypesService;
import org.ovirt.engine.sdk4.types.OpenStackVolumeProvider;

public class OpenstackVolumeProviderServiceImpl
extends ExternalProviderServiceImpl
implements OpenstackVolumeProviderService {
    public OpenstackVolumeProviderServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public OpenstackVolumeProviderService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public OpenstackVolumeProviderService.RemoveRequest remove() {
        return new RemoveRequestImpl();
    }

    @Override
    public OpenstackVolumeProviderService.UpdateRequest update() {
        return new UpdateRequestImpl();
    }

    @Override
    public OpenstackVolumeAuthenticationKeysService authenticationKeysService() {
        return new OpenstackVolumeAuthenticationKeysServiceImpl(this.getConnection(), this.getPath() + "/authenticationkeys");
    }

    @Override
    public ExternalProviderCertificatesService certificatesService() {
        return new ExternalProviderCertificatesServiceImpl(this.getConnection(), this.getPath() + "/certificates");
    }

    @Override
    public OpenstackVolumeTypesService volumeTypesService() {
        return new OpenstackVolumeTypesServiceImpl(this.getConnection(), this.getPath() + "/volumetypes");
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        if (path.equals("authenticationkeys")) {
            return this.authenticationKeysService();
        }
        if (path.startsWith("authenticationkeys/")) {
            return this.authenticationKeysService().service(path.substring(19));
        }
        if (path.equals("certificates")) {
            return this.certificatesService();
        }
        if (path.startsWith("certificates/")) {
            return this.certificatesService().service(path.substring(13));
        }
        if (path.equals("volumetypes")) {
            return this.volumeTypesService();
        }
        if (path.startsWith("volumetypes/")) {
            return this.volumeTypesService().service(path.substring(12));
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    @Override
    public String toString() {
        return "OpenstackVolumeProviderService:" + this.getPath();
    }

    private class UpdateResponseImpl
    implements OpenstackVolumeProviderService.UpdateResponse {
        private OpenStackVolumeProvider provider;

        private UpdateResponseImpl() {
        }

        public void provider(OpenStackVolumeProvider provider) {
            this.provider = provider;
        }

        @Override
        public OpenStackVolumeProvider provider() {
            return this.provider;
        }
    }

    private class UpdateRequestImpl
    extends BaseRequest<OpenstackVolumeProviderService.UpdateRequest, OpenstackVolumeProviderService.UpdateResponse>
    implements OpenstackVolumeProviderService.UpdateRequest {
        private Boolean async;
        private OpenStackVolumeProvider provider;

        private UpdateRequestImpl() {
        }

        @Override
        public OpenstackVolumeProviderService.UpdateRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public OpenstackVolumeProviderService.UpdateRequest provider(OpenStackVolumeProvider provider) {
            this.provider = provider;
            return this;
        }

        @Override
        public OpenstackVolumeProviderService.UpdateRequest provider(OpenStackVolumeProviderBuilder provider) {
            this.provider = provider.build();
            return this;
        }

        @Override
        public OpenstackVolumeProviderService.UpdateResponse send() {
            HttpResponse response;
            HttpPut request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(OpenstackVolumeProviderServiceImpl.this.getConnection().getUrl() + OpenstackVolumeProviderServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPut(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlOpenStackVolumeProviderWriter.writeOne(this.provider, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = OpenstackVolumeProviderServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        UpdateResponseImpl actionResponse = new UpdateResponseImpl();
                        actionResponse.provider(XmlOpenStackVolumeProviderReader.readOne(reader));
                        UpdateResponseImpl updateResponseImpl = actionResponse;
                        reader.close();
                        return updateResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            OpenstackVolumeProviderServiceImpl.this.checkFault(response);
            return new UpdateResponseImpl();
        }
    }

    private class RemoveResponseImpl
    implements OpenstackVolumeProviderService.RemoveResponse {
        private RemoveResponseImpl() {
        }
    }

    private class RemoveRequestImpl
    extends BaseRequest<OpenstackVolumeProviderService.RemoveRequest, OpenstackVolumeProviderService.RemoveResponse>
    implements OpenstackVolumeProviderService.RemoveRequest {
        private Boolean async;
        private Boolean force;

        private RemoveRequestImpl() {
        }

        @Override
        public OpenstackVolumeProviderService.RemoveRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public OpenstackVolumeProviderService.RemoveRequest force(Boolean force) {
            this.force = force;
            return this;
        }

        @Override
        public OpenstackVolumeProviderService.RemoveResponse send() {
            HttpResponse response;
            HttpDelete request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(OpenstackVolumeProviderServiceImpl.this.getConnection().getUrl() + OpenstackVolumeProviderServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.force != null) {
                    uriBuilder.addParameter("force", XmlWriter.renderBoolean(this.force));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpDelete(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = OpenstackVolumeProviderServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return new RemoveResponseImpl();
            }
            OpenstackVolumeProviderServiceImpl.this.checkFault(response);
            return new RemoveResponseImpl();
        }
    }

    private class GetResponseImpl
    implements OpenstackVolumeProviderService.GetResponse {
        private OpenStackVolumeProvider provider;

        private GetResponseImpl() {
        }

        public void provider(OpenStackVolumeProvider provider) {
            this.provider = provider;
        }

        @Override
        public OpenStackVolumeProvider provider() {
            return this.provider;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<OpenstackVolumeProviderService.GetRequest, OpenstackVolumeProviderService.GetResponse>
    implements OpenstackVolumeProviderService.GetRequest {
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public OpenstackVolumeProviderService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public OpenstackVolumeProviderService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(OpenstackVolumeProviderServiceImpl.this.getConnection().getUrl() + OpenstackVolumeProviderServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = OpenstackVolumeProviderServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.provider(XmlOpenStackVolumeProviderReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            OpenstackVolumeProviderServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }
}

