/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ImageTransferPhase {
    CANCELLED("cancelled"),
    CANCELLED_SYSTEM("cancelled_system"),
    CANCELLED_USER("cancelled_user"),
    FINALIZING_CLEANUP("finalizing_cleanup"),
    FINALIZING_FAILURE("finalizing_failure"),
    FINALIZING_SUCCESS("finalizing_success"),
    FINISHED_CLEANUP("finished_cleanup"),
    FINISHED_FAILURE("finished_failure"),
    FINISHED_SUCCESS("finished_success"),
    INITIALIZING("initializing"),
    PAUSED_SYSTEM("paused_system"),
    PAUSED_USER("paused_user"),
    RESUMING("resuming"),
    TRANSFERRING("transferring"),
    UNKNOWN("unknown");

    private static final Logger log;
    private String image;

    private ImageTransferPhase(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static ImageTransferPhase fromValue(String value) {
        try {
            return ImageTransferPhase.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'ImageTransferPhase' enumerated type. Valid values are 'cancelled', 'cancelled_system', 'cancelled_user', 'finalizing_cleanup', 'finalizing_failure', 'finalizing_success', 'finished_cleanup', 'finished_failure', 'finished_success', 'initializing', 'paused_system', 'paused_user', 'resuming', 'transferring' and 'unknown'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(ImageTransferPhase.class);
    }
}

