/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.xml;

import java.util.Iterator;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.types.MDevType;

public class XmlMDevTypeWriter {
    
    public static void writeOne(MDevType object, XmlWriter writer) {
        writeOne(object, "m_dev_type", writer);
    }
    
    public static void writeOne(MDevType object, String tag, XmlWriter writer) {
        writer.writeStartElement(tag);
        if (object.availableInstancesPresent()) {
            writer.writeInteger("available_instances", object.availableInstances());
        }
        if (object.descriptionPresent()) {
            writer.writeElement("description", object.description());
        }
        if (object.humanReadableNamePresent()) {
            writer.writeElement("human_readable_name", object.humanReadableName());
        }
        if (object.namePresent()) {
            writer.writeElement("name", object.name());
        }
        writer.writeEndElement();
    }
    
    public static void writeMany(Iterator<MDevType> list, XmlWriter writer) {
        writeMany(list, "m_dev_type", "m_dev_types", writer);
    }
    
    public static void writeMany(Iterator<MDevType> list, String singular, String plural, XmlWriter writer) {
        writer.writeStartElement(plural);
        while (list.hasNext()) {
            XmlMDevTypeWriter.writeOne(list.next(), singular, writer);
        }
        writer.writeEndElement();
    }
    
}

