/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.ClusterAffinityGroup;
import org.ovirt.engine.sdk.decorators.ClusterAffinityGroupVM;
import org.ovirt.engine.sdk.entities.VM;
import org.ovirt.engine.sdk.entities.VMs;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class ClusterAffinityGroupVMs
extends CollectionDecorator<VM, VMs, ClusterAffinityGroupVM> {
    private ClusterAffinityGroup parent;

    public ClusterAffinityGroupVMs(HttpProxyBroker proxy, ClusterAffinityGroup parent) {
        super(proxy, "vms");
        this.parent = parent;
    }

    @Override
    public List<ClusterAffinityGroupVM> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, VMs.class, ClusterAffinityGroupVM.class);
    }

    @Override
    public ClusterAffinityGroupVM get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, VM.class, ClusterAffinityGroupVM.class);
    }

    @Override
    public ClusterAffinityGroupVM getById(String id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id;
        return this.getProxy().get(url, VM.class, ClusterAffinityGroupVM.class);
    }

    public ClusterAffinityGroupVM add(VM vm) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, vm, VM.class, ClusterAffinityGroupVM.class, headers);
    }

    public ClusterAffinityGroupVM add(VM vm, String expect) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (expect != null) {
            headersBuilder.add("Expect", expect);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, vm, VM.class, ClusterAffinityGroupVM.class, headers);
    }

    public ClusterAffinityGroupVM add(VM vm, String expect, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (expect != null) {
            headersBuilder.add("Expect", expect);
        }
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, vm, VM.class, ClusterAffinityGroupVM.class, headers);
    }

    public List<ClusterAffinityGroupVM> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(this.parent.getHref() + "/" + this.getName());
        if (max != null) {
            urlBuilder.add("max", max, UrlParameterType.MATRIX);
        }
        String url = urlBuilder.build();
        return this.list(url, VMs.class, ClusterAffinityGroupVM.class, headers);
    }
}

