/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.DataCenterClusterAffinityGroup;
import org.ovirt.engine.sdk.decorators.DataCenterClusterAffinityGroupVM;
import org.ovirt.engine.sdk.entities.VM;
import org.ovirt.engine.sdk.entities.VMs;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class DataCenterClusterAffinityGroupVMs
extends CollectionDecorator<VM, VMs, DataCenterClusterAffinityGroupVM> {
    private DataCenterClusterAffinityGroup parent;

    public DataCenterClusterAffinityGroupVMs(HttpProxyBroker proxy, DataCenterClusterAffinityGroup parent) {
        super(proxy, "vms");
        this.parent = parent;
    }

    @Override
    public List<DataCenterClusterAffinityGroupVM> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, VMs.class, DataCenterClusterAffinityGroupVM.class);
    }

    @Override
    public DataCenterClusterAffinityGroupVM get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, VM.class, DataCenterClusterAffinityGroupVM.class);
    }

    @Override
    public DataCenterClusterAffinityGroupVM getById(String id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id;
        return this.getProxy().get(url, VM.class, DataCenterClusterAffinityGroupVM.class);
    }

    public DataCenterClusterAffinityGroupVM add(VM vm) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, vm, VM.class, DataCenterClusterAffinityGroupVM.class, headers);
    }

    public List<DataCenterClusterAffinityGroupVM> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(this.parent.getHref() + "/" + this.getName());
        if (max != null) {
            urlBuilder.add("max", max, UrlParameterType.MATRIX);
        }
        String url = urlBuilder.build();
        return this.list(url, VMs.class, DataCenterClusterAffinityGroupVM.class, headers);
    }
}

