/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.Host;
import org.ovirt.engine.sdk.decorators.HostKatelloErratum;
import org.ovirt.engine.sdk.entities.KatelloErrata;
import org.ovirt.engine.sdk.entities.KatelloErratum;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class HostKatelloErrata
extends CollectionDecorator<KatelloErratum, KatelloErrata, HostKatelloErratum> {
    private Host parent;

    public HostKatelloErrata(HttpProxyBroker proxy, Host parent) {
        super(proxy, "katelloerrata");
        this.parent = parent;
    }

    @Override
    public List<HostKatelloErratum> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, KatelloErrata.class, HostKatelloErratum.class);
    }

    @Override
    public HostKatelloErratum get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, KatelloErratum.class, HostKatelloErratum.class);
    }

    @Override
    public HostKatelloErratum getById(String id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id;
        return this.getProxy().get(url, KatelloErratum.class, HostKatelloErratum.class);
    }

    public List<HostKatelloErratum> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(this.parent.getHref() + "/" + this.getName());
        if (max != null) {
            urlBuilder.add("max", max, UrlParameterType.MATRIX);
        }
        String url = urlBuilder.build();
        return this.list(url, KatelloErrata.class, HostKatelloErratum.class, headers);
    }
}

