/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.Host;
import org.ovirt.engine.sdk.decorators.HostUnmanagedNetwork;
import org.ovirt.engine.sdk.entities.UnmanagedNetwork;
import org.ovirt.engine.sdk.entities.UnmanagedNetworks;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class HostUnmanagedNetworks
extends CollectionDecorator<UnmanagedNetwork, UnmanagedNetworks, HostUnmanagedNetwork> {
    private Host parent;

    public HostUnmanagedNetworks(HttpProxyBroker proxy, Host parent) {
        super(proxy, "unmanagednetworks");
        this.parent = parent;
    }

    @Override
    public List<HostUnmanagedNetwork> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, UnmanagedNetworks.class, HostUnmanagedNetwork.class);
    }

    @Override
    public HostUnmanagedNetwork get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, UnmanagedNetwork.class, HostUnmanagedNetwork.class);
    }

    @Override
    public HostUnmanagedNetwork getById(String id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id;
        return this.getProxy().get(url, UnmanagedNetwork.class, HostUnmanagedNetwork.class);
    }

    public List<HostUnmanagedNetwork> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(this.parent.getHref() + "/" + this.getName());
        if (max != null) {
            urlBuilder.add("max", max, UrlParameterType.MATRIX);
        }
        String url = urlBuilder.build();
        return this.list(url, UnmanagedNetworks.class, HostUnmanagedNetwork.class, headers);
    }
}

