/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.VMNIC;
import org.ovirt.engine.sdk.decorators.VMNICStatistic;
import org.ovirt.engine.sdk.entities.Statistic;
import org.ovirt.engine.sdk.entities.Statistics;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.web.HttpProxyBroker;

public class VMNICStatistics
extends CollectionDecorator<Statistic, Statistics, VMNICStatistic> {
    private VMNIC parent;

    public VMNICStatistics(HttpProxyBroker proxy, VMNIC parent) {
        super(proxy, "statistics");
        this.parent = parent;
    }

    @Override
    public List<VMNICStatistic> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, Statistics.class, VMNICStatistic.class);
    }

    @Override
    public VMNICStatistic get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, Statistic.class, VMNICStatistic.class);
    }

    @Override
    public VMNICStatistic getById(String id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id;
        return this.getProxy().get(url, Statistic.class, VMNICStatistic.class);
    }
}

