#
# vdsm-jsonrpc-java - vdsm json rpc
# Copyright (C) 2013-2016 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
#

%global		package_version 1.4.13
%global		package_maven_version 1.4.13

%if 0%{?fedora:1}
%global	_use_maven 1
%endif
%if 0%{?rhel:1}
%global	_mvn_opts -Pno-test
%global	_use_maven 1
%endif

Summary:	JsonRpc java client (%{name}) for oVirt
Name:		vdsm-jsonrpc-java
Version:	1.4.13
Release:	1%{?release_suffix}%{?dist}
License:	LGPLv2+
URL:		http://www.ovirt.org
Source:		http://resources.ovirt.org/pub/ovirt-master-snapshot/src/%{name}/%{name}-%{package_version}.tar.gz
Group:		Development/Libraries

BuildArch:	noarch


BuildRequires:	apache-commons-lang >= 2.6
BuildRequires:	jackson >= 1.9
BuildRequires:	java-1.8.0-openjdk-devel >= 1:1.8.0
BuildRequires:	slf4j >= 1.7.0

%if %{_use_maven}
BuildRequires:	junit
BuildRequires:	maven-compiler-plugin
BuildRequires:	maven-enforcer-plugin
BuildRequires:	maven-install-plugin
BuildRequires:	maven-jar-plugin
BuildRequires:	maven-javadoc-plugin
BuildRequires:	maven-local
BuildRequires:	maven-source-plugin
BuildRequires:	maven-surefire-provider-junit
BuildRequires:	mockito
BuildRequires:	sonatype-oss-parent
%endif

Requires:	apache-commons-lang >= 2.6
Requires:	jackson >= 1.9
Requires:	java-openjdk-headless >= 1.8.0
Requires:	slf4j >= 1.7.0

%description
vdsm jsonrpc java

%if %{_use_maven}
%package javadoc
Summary:	Java-docs for %{name}
Group:		Documentation

%description javadoc
This package contains the API documentation for %{name}.
%endif

%prep
%setup -q -n %{name}-%{package_version}

%build
%if %{_use_maven}
%global conf --with-maven --disable-java-build
%else
%global conf \\\
	JACKSON_CORE_ASL=$(build-classpath jackson/jackson-core-asl) \\\
	JACKSON_MAPPER_ASL=$(build-classpath jackson/jackson-mapper-asl) \\\
	SLF4J_JAR=$(build-classpath slf4j) \\\
	COMMONS_LANG_JAR=$(build-classpath apache-commons-lang) \\\
	JAVAC=/usr/lib/jvm/java-1.8.0/bin/javac \\\
	JAR=/usr/lib/jvm/java-1.8.0/bin/jar \\\
	%{?null}
%endif
%configure %{?conf}
make %{?_smp_mflags}

%if %{_use_maven}
%mvn_build -- %{?_mvn_opts}
%endif

%install
make %{?_smp_mflags} install DESTDIR="%{buildroot}"

%if %{_use_maven}
%mvn_install
%else
install -d "%{buildroot}%{_javadir}/%{name}"
FILE=$(ls -1 target/%{name}-client*.jar | grep -v source | grep -v javadoc | xargs -n 1 basename)
install target/$FILE %{buildroot}%{_javadir}/%{name}
ln -s $FILE %{buildroot}%{_javadir}/%{name}/%{name}-client.jar
%endif

%if %{_use_maven}
%files -f .mfiles
%dir %{_javadir}/%{name}
%else
%files
%dir %{_javadir}/%{name}
%{_javadir}/%{name}/%{name}*.jar
%endif

%if %{_use_maven}
%files javadoc -f .mfiles-javadoc
%endif

%changelog
* Wed May 9 2018 Piotr Kliczewski <pkliczew@redhat.com> 1.4.13
- Rephrase Heartbeat exceeded error message
- Connections shouldn't be closed after the connection to the host was recovered

* Fri Apr 13 2018 Piotr Kliczewski <pkliczew@redhat.com> 1.4.12
- Don't retry async calls on connection error

* Fri Dec 15 2017 Piotr Kliczewski <pkliczew@redhat.com> 1.4.11
- Heartbeat logging

* Mon Dec 4 2017 Piotr Kliczewski <pkliczew@redhat.com> 1.4.10
- Heartbeat logging improvements

* Thu Nov 20 2017 Piotr Kliczewski <pkliczew@redhat.com> 1.4.9
- Release host level lock faster

* Thu Oct 19 2017 Piotr Kliczewski <pkliczew@redhat.com> 1.4.8
- host to id mapping needs to be cleared on failure

* Wed Sep 20 2017 Piotr Kliczewski <pkliczew@redhat.com> 1.4.7
- Adding callbacks infrastructure to use non-blocking threads

* Tue Apr 11 2017 Piotr Kliczewski <pkliczew@redhat.com> 1.4.6
- send correlation id to the server

* Mon Mar 27 2017 Piotr Kliczewski <pkliczew@redhat.com> 1.4.5
- java exception visible in Events when upgrade check is done on recently fenced host
- packaging: spec: move to headless java

* Thu Mar 9 2017 Piotr Kliczewski <pkliczew@redhat.com> 1.4.4
- remove end of line before command

* Wed Feb 22 2017 Piotr Kliczewski <pkliczew@redhat.com> 1.4.3
- incomplete message BZ #1425725

* Wed Jan 18 2017 Piotr Kliczewski <pkliczew@redhat.com> 1.4.2
- process messages one by one

* Thu Jan 12 2017 Piotr Kliczewski <pkliczew@redhat.com> 1.4.1
- handle ssl closed status

* Mon Jan 9 2017 Piotr Kliczewski <pkliczew@redhat.com> 1.4.0
- Make sure to match host properly
- Add cause exception upon re-throwing IOException in ReactorClient
- Frame split when using multiple hosts

* Fri Dec 2 2016 Piotr Kliczewski <pkliczew@redhat.com> 1.3.5
- stop processing if closing

* Fri Nov 18 2016 Piotr Kliczewski <pkliczew@redhat.com> 1.3.4
- Closing channel could take too much reactor's time

* Fri Nov 4 2016 Piotr Kliczewski <pkliczew@redhat.com> 1.3.3
- Release for 4.1

* Wed Oct 12 2016 Piotr Kliczewski <pkliczew@redhat.com> 1.3.2
- No reconnect during setupNetworks

* Mon Sep 5 2016 Piotr Kliczewski <pkliczew@redhat.com> 1.3.1
- Release of 1.3.1

* Wed Jun 29 2016 Piotr Kliczewski <pkliczew@redhat.com> 1.2.5
- wait on close

* Tue Jun 28 2016 Piotr Kliczewski <pkliczew@redhat.com> 1.2.4
- schedule close when we reset policy

* Tue May 31 2016 Piotr Kliczewski <pkliczew@redhat.com> 1.2.3
- Release of 1.2.3

* Mon Feb 8 2016 Piotr Kliczewski <pkliczew@redhat.com> 1.2.1
- Initial release of 4.0

* Tue Jan 19 2016 Piotr Kliczewski <pkliczew@redhat.com> 1.1.7-1
- Exception shouldn't be recursive

* Fri Jan 8 2016 Piotr Kliczewski <pkliczew@redhat.com> 1.1.6-1
- scheduled tasks do not check whether a channel is there
- i/o thread blocked during connection

* Thu Sep 24 2015 Piotr Kliczewski <pkliczew@redhat.com> 1.1.5-1
- Releasing for RC

* Wed Jul 15 2015 Piotr Kliczewski <pkliczew@redhat.com 1.1.4
- Update report ceritification expiration date
- Fix spelling mistake

* Sun Jul 5 2015 Piotr Kliczewski <pkliczew@redhat.com 1.1.3-2
- Version update

* Wed Jul 1 2015 Piotr Kliczewski <pkliczew@redhat.com> 1.1.3-1
- Matching side effect fix
- Report certification expiration date

* Wed Jun 10 2015 Piotr Kliczewski <pkliczew@redhat.com> 1.1.2-1
- Introduced new queue for events

* Mon Apr 20 2015 Piotr Kliczewski <pkliczew@redhat.com> 1.1.1
- Introduction of Events

* Tue Apr 7 2015 Piotr Kliczewski <pkliczew@redhat.com> 1.1.0
- Initial release for 3.6
