/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.maven.surefire.shade.org.codehaus.plexus.util.IOUtil;
import org.apache.maven.surefire.util.TeeStream;

public class SystemStreamCapturer {
    private final PrintStream oldOut;
    private final PrintStream oldErr;
    private final PrintStream newErr;
    private final PrintStream newOut;
    private final ByteArrayOutputStream stdOut = new ByteArrayOutputStream();
    private final ByteArrayOutputStream stdErr;

    public SystemStreamCapturer() {
        this.newOut = new PrintStream(this.stdOut);
        this.oldOut = System.out;
        TeeStream tee = new TeeStream(this.oldOut, this.newOut);
        System.setOut(tee);
        this.stdErr = new ByteArrayOutputStream();
        this.newErr = new PrintStream(this.stdErr);
        this.oldErr = System.err;
        tee = new TeeStream(this.oldErr, this.newErr);
        System.setErr(tee);
    }

    public void restoreStreams() {
        if (this.oldOut != null) {
            System.setOut(this.oldOut);
        }
        if (this.oldErr != null) {
            System.setErr(this.oldErr);
        }
        IOUtil.close(this.newOut);
        IOUtil.close(this.newErr);
    }

    public void clearCapturedContent() {
        if (this.stdOut != null) {
            this.stdOut.reset();
        }
        if (this.stdErr != null) {
            this.stdErr.reset();
        }
    }

    public String getStdOutLog() {
        return this.stdOut != null ? this.stdOut.toString() : "";
    }

    public String getStdErrLog() {
        return this.stdErr != null ? this.stdErr.toString() : "";
    }
}

