/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.example;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;

public class ResultSetTest {
    private ArrayList<String> m_results;

    public static Iterator<String> executeSelect(String selectSQL) throws SQLException {
        if (!selectSQL.toUpperCase().trim().startsWith("SELECT ")) {
            throw new SQLException("Not a SELECT statement");
        }
        return new ResultSetTest(selectSQL).iterator();
    }

    public ResultSetTest(String selectSQL) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        this.m_results = new ArrayList();
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(selectSQL);
        ResultSetMetaData rsmd = rs.getMetaData();
        int cnt = rsmd.getColumnCount();
        StringBuffer result = new StringBuffer();
        for (int i = 1; i <= cnt; ++i) {
            result.append((rsmd.getColumnName(i) + "(" + rsmd.getColumnClassName(i) + ")").replaceAll("(\\\\|;)", "\\$1") + ";");
        }
        this.m_results.add(result.toString());
        while (rs.next()) {
            result = new StringBuffer();
            Object rsObject = null;
            for (int i = 1; i <= cnt; ++i) {
                rsObject = rs.getObject(i);
                if (rsObject == null) {
                    rsObject = "<NULL>";
                }
                result.append(rsObject.toString().replaceAll("(\\\\|;)", "\\$1") + ";");
            }
            this.m_results.add(result.toString());
        }
        rs.close();
    }

    public void close() {
    }

    private Iterator<String> iterator() {
        return this.m_results.iterator();
    }
}

