/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.filtering;

import java.io.BufferedReader;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.codehaus.plexus.interpolation.SimpleRecursionInterceptor;
import org.codehaus.plexus.interpolation.multi.DelimiterSpecification;

public class MultiDelimiterInterpolatorFilterReaderLineEnding
extends FilterReader {
    private Interpolator interpolator;
    private RecursionInterceptor recursionInterceptor;
    private String replaceData = null;
    private int replaceIndex = 0;
    public static final String DEFAULT_BEGIN_TOKEN = "${";
    public static final String DEFAULT_END_TOKEN = "}";
    private boolean interpolateWithPrefixPattern = true;
    private String escapeString;
    private boolean useEscape = false;
    private boolean preserveEscapeString = false;
    private LinkedHashSet delimiters = new LinkedHashSet();
    private String beginToken;
    private String endToken;
    private boolean supportMultiLineFiltering;
    private int markLength = 16;
    private boolean eof = false;

    public MultiDelimiterInterpolatorFilterReaderLineEnding(Reader in, Interpolator interpolator, boolean supportMultiLineFiltering) {
        this(in, interpolator, (RecursionInterceptor)new SimpleRecursionInterceptor(), supportMultiLineFiltering);
    }

    public MultiDelimiterInterpolatorFilterReaderLineEnding(Reader in, Interpolator interpolator, RecursionInterceptor ri, boolean supportMultiLineFiltering) {
        super(new BufferedReader(in));
        this.interpolator = interpolator;
        this.interpolator.setCacheAnswers(true);
        this.recursionInterceptor = ri;
        this.delimiters.add(DelimiterSpecification.DEFAULT_SPEC);
        this.supportMultiLineFiltering = supportMultiLineFiltering;
        this.calculateMarkLength();
    }

    public boolean removeDelimiterSpec(String delimiterSpec) {
        return this.delimiters.remove(DelimiterSpecification.parse((String)delimiterSpec));
    }

    public MultiDelimiterInterpolatorFilterReaderLineEnding setDelimiterSpecs(HashSet specs) {
        this.delimiters.clear();
        for (String spec : specs) {
            this.delimiters.add(DelimiterSpecification.parse((String)spec));
            this.markLength += spec.length() * 2;
        }
        return this;
    }

    public long skip(long n) throws IOException {
        if (n < 0L) {
            throw new IllegalArgumentException("skip value is negative");
        }
        for (long i = 0L; i < n; ++i) {
            if (this.read() != -1) continue;
            return i;
        }
        return n;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            int ch = this.read();
            if (ch == -1) {
                if (i == 0) {
                    return -1;
                }
                return i;
            }
            cbuf[off + i] = (char)ch;
        }
        return len;
    }

    public int read() throws IOException {
        if (this.replaceIndex > 0) {
            return this.replaceData.charAt(this.replaceData.length() - this.replaceIndex--);
        }
        if (this.eof) {
            return -1;
        }
        this.in.mark(this.markLength);
        int ch = this.in.read();
        if (ch == -1 || ch == 10 && !this.supportMultiLineFiltering) {
            return ch;
        }
        boolean inEscape = this.useEscape && ch == this.escapeString.charAt(0);
        StringBuffer key = new StringBuffer();
        if (inEscape) {
            for (int i = 0; i < this.escapeString.length(); ++i) {
                key.append((char)ch);
                if (ch != this.escapeString.charAt(i) || ch == -1 || ch == 10 && !this.supportMultiLineFiltering) {
                    this.in.reset();
                    inEscape = false;
                    key.setLength(0);
                    break;
                }
                ch = this.in.read();
            }
        }
        int max = 0;
        for (DelimiterSpecification spec : this.delimiters) {
            String begin = spec.getBegin();
            if (begin.length() < max) continue;
            for (int i = 0; i < begin.length() && ch == begin.charAt(i) && ch != -1 && (ch != 10 || this.supportMultiLineFiltering); ++i) {
                if (i == begin.length() - 1) {
                    this.beginToken = spec.getBegin();
                    this.endToken = spec.getEnd();
                }
                ch = this.in.read();
            }
            this.in.reset();
            this.in.skip(key.length());
            ch = this.in.read();
        }
        if (inEscape) {
            if (this.beginToken != null && !this.preserveEscapeString) {
                key.setLength(0);
            }
            this.beginToken = null;
            this.endToken = null;
            key.append((char)ch);
            this.replaceData = key.toString();
            this.replaceIndex = key.length();
            return this.read();
        }
        if (this.beginToken == null || this.beginToken.length() == 0 || this.endToken == null || this.endToken.length() == 0) {
            this.in.reset();
            return this.in.read();
        }
        key.append(this.beginToken);
        this.in.reset();
        this.in.skip(this.beginToken.length());
        ch = this.in.read();
        int end = this.endToken.length();
        while (ch != -1) {
            if (ch == 10 && !this.supportMultiLineFiltering) {
                key.append((char)ch);
                break;
            }
            key.append((char)ch);
            if (ch == this.endToken.charAt(end - 1)) {
                if (--end == 0) {
                    break;
                }
            } else {
                end = this.endToken.length();
            }
            ch = this.in.read();
        }
        this.beginToken = null;
        this.endToken = null;
        String value = null;
        if (end == 0) {
            try {
                value = this.interpolateWithPrefixPattern ? this.interpolator.interpolate(key.toString(), "", this.recursionInterceptor) : this.interpolator.interpolate(key.toString(), this.recursionInterceptor);
            }
            catch (InterpolationException e) {
                IllegalArgumentException error = new IllegalArgumentException(e.getMessage());
                error.initCause(e);
                throw error;
            }
        }
        if (value != null) {
            this.replaceData = value;
            this.replaceIndex = value.length();
        } else {
            this.replaceData = key.toString();
            this.replaceIndex = key.length();
        }
        if (ch == -1) {
            this.eof = true;
        }
        return this.read();
    }

    public boolean isInterpolateWithPrefixPattern() {
        return this.interpolateWithPrefixPattern;
    }

    public void setInterpolateWithPrefixPattern(boolean interpolateWithPrefixPattern) {
        this.interpolateWithPrefixPattern = interpolateWithPrefixPattern;
    }

    public String getEscapeString() {
        return this.escapeString;
    }

    public void setEscapeString(String escapeString) {
        if (escapeString != null && escapeString.length() >= 1) {
            this.escapeString = escapeString;
            this.useEscape = escapeString != null && escapeString.length() >= 1;
            this.calculateMarkLength();
        }
    }

    public boolean isPreserveEscapeString() {
        return this.preserveEscapeString;
    }

    public void setPreserveEscapeString(boolean preserveEscapeString) {
        this.preserveEscapeString = preserveEscapeString;
    }

    public RecursionInterceptor getRecursionInterceptor() {
        return this.recursionInterceptor;
    }

    public MultiDelimiterInterpolatorFilterReaderLineEnding setRecursionInterceptor(RecursionInterceptor recursionInterceptor) {
        this.recursionInterceptor = recursionInterceptor;
        return this;
    }

    private void calculateMarkLength() {
        this.markLength = 16;
        if (this.escapeString != null) {
            this.markLength += this.escapeString.length();
        }
        for (DelimiterSpecification spec : this.delimiters) {
            this.markLength += spec.getBegin().length();
            this.markLength += spec.getEnd().length();
        }
    }
}

