/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.plexus.rest.xstream.xml;

import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.sonatype.plexus.rest.xstream.xml.LookAheadXppReader;

public class LookAheadXppDriver
extends XppDriver {
    private static boolean xppLibraryPresent;

    public LookAheadXppDriver() {
        super((NameCoder)new XmlFriendlyNameCoder());
    }

    public HierarchicalStreamReader createReader(Reader xml) {
        this.loadLibrary();
        return new LookAheadXppReader(xml, this.getNameCoder());
    }

    public HierarchicalStreamReader createReader(InputStream in) {
        return this.createReader(new InputStreamReader(in));
    }

    private void loadLibrary() {
        if (!xppLibraryPresent) {
            try {
                ((Object)((Object)this)).getClass().getClassLoader().loadClass("io.github.xstream.mxparser.MXParser");
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("XPP3 pull parser library not present. Specify another driver. For example: new XStream(new DomDriver())", e);
            }
            xppLibraryPresent = true;
        }
    }

    public HierarchicalStreamWriter createWriter(Writer out) {
        return new PrettyPrintWriter(out, this.getNameCoder());
    }

    public HierarchicalStreamWriter createWriter(OutputStream out) {
        return this.createWriter(new OutputStreamWriter(out));
    }
}

