/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.spice.zapper.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.sonatype.spice.zapper.ZFile;
import org.sonatype.spice.zapper.internal.AbstractIdentified;
import org.sonatype.spice.zapper.internal.Check;
import org.sonatype.spice.zapper.internal.PayloadSupplier;
import org.sonatype.spice.zapper.internal.PayloadSupplierImpl;
import org.sonatype.spice.zapper.internal.Segment;
import org.sonatype.spice.zapper.internal.SegmentIdentifier;
import org.sonatype.spice.zapper.internal.SegmentPayload;
import org.sonatype.spice.zapper.internal.TransferIdentifier;
import org.sonatype.spice.zapper.internal.transport.TrackIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transfer
extends AbstractIdentified<TransferIdentifier> {
    private final List<ZFile> zfiles;
    private final List<Segment> segments;
    private final List<SegmentPayload> payloads;
    private final long totalSize;
    private final AtomicInteger segmentCounter = new AtomicInteger(1);
    private final AtomicInteger trackCounter = new AtomicInteger(1);

    public Transfer(String transferIdentifier, List<ZFile> zfiles) {
        super(new TransferIdentifier(transferIdentifier));
        this.zfiles = Collections.unmodifiableList(Check.notNull(zfiles, List.class));
        this.segments = new ArrayList<Segment>();
        this.payloads = new ArrayList<SegmentPayload>();
        long ts = 0L;
        for (ZFile zfile : zfiles) {
            ts += zfile.getLength();
        }
        this.totalSize = ts;
    }

    public SegmentIdentifier getNextSegmentIdentifier() {
        return new SegmentIdentifier("S" + String.valueOf(this.segmentCounter.getAndIncrement()));
    }

    public TrackIdentifier getNextTrackIdentifier() {
        return new TrackIdentifier("T" + String.valueOf(this.trackCounter.getAndIncrement()));
    }

    public List<ZFile> getZfiles() {
        return this.zfiles;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public List<Segment> getSegments() {
        return Collections.unmodifiableList(this.segments);
    }

    public void setSegments(List<Segment> segments) {
        this.segments.clear();
        this.segments.addAll(segments);
    }

    public List<SegmentPayload> getPayloads() {
        return Collections.unmodifiableList(this.payloads);
    }

    public void setPayloads(List<SegmentPayload> payloads) {
        this.payloads.clear();
        this.payloads.addAll(payloads);
    }

    public PayloadSupplier getPayloadSupplier() {
        return new PayloadSupplierImpl(this.getPayloads());
    }
}

