/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.internal.rest.jersey.subsystem.repository;

import org.sonatype.nexus.client.core.subsystem.repository.RepositoryStatus;
import org.sonatype.nexus.client.core.subsystem.repository.VirtualRepository;
import org.sonatype.nexus.client.internal.rest.jersey.subsystem.repository.JerseyRepository;
import org.sonatype.nexus.client.rest.jersey.JerseyNexusClient;
import org.sonatype.nexus.rest.model.RepositoryShadowResource;

public class JerseyVirtualRepository<T extends VirtualRepository>
extends JerseyRepository<T, RepositoryShadowResource, RepositoryStatus>
implements VirtualRepository<T> {
    static final String REPO_TYPE = "virtual";
    static final String PROVIDER_ROLE = "org.sonatype.nexus.proxy.repository.ShadowRepository";

    public JerseyVirtualRepository(JerseyNexusClient nexusClient, String id) {
        super(nexusClient, id);
    }

    public JerseyVirtualRepository(JerseyNexusClient nexusClient, RepositoryShadowResource settings) {
        super(nexusClient, settings);
    }

    @Override
    protected RepositoryShadowResource createSettings() {
        RepositoryShadowResource settings = new RepositoryShadowResource();
        settings.setRepoType(REPO_TYPE);
        settings.setProviderRole(PROVIDER_ROLE);
        settings.setExposed(true);
        return settings;
    }

    private T me() {
        return (T)this;
    }

    @Override
    public String virtualizedRepository() {
        return ((RepositoryShadowResource)this.settings()).getShadowOf();
    }

    @Override
    public T ofRepository(String repositoryId) {
        ((RepositoryShadowResource)this.settings()).setShadowOf(repositoryId);
        return this.me();
    }
}

