/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency.analyze;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="analyze-dep-mgt", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class AnalyzeDepMgt
extends AbstractMojo {
    @Component
    private MavenProject project;
    @Parameter(property="mdep.analyze.failBuild", defaultValue="false")
    private boolean failBuild = false;
    @Parameter(property="mdep.analyze.ignore.direct", defaultValue="true")
    private boolean ignoreDirect = true;
    @Parameter(property="mdep.analyze.skip", defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"Skipping plugin execution");
            return;
        }
        boolean result = this.checkDependencyManagement();
        if (result) {
            if (this.failBuild) {
                throw new MojoExecutionException("Found Dependency errors.");
            }
            this.getLog().warn((CharSequence)"Potential problems found in Dependency Management ");
        }
    }

    private boolean checkDependencyManagement() throws MojoExecutionException {
        boolean foundError = false;
        this.getLog().info((CharSequence)"Found Resolved Dependency / DependencyManagement mismatches:");
        List depMgtDependencies = null;
        DependencyManagement depMgt = this.project.getDependencyManagement();
        if (depMgt != null) {
            depMgtDependencies = depMgt.getDependencies();
        }
        if (depMgtDependencies != null && !depMgtDependencies.isEmpty()) {
            HashMap<String, Dependency> depMgtMap = new HashMap<String, Dependency>();
            HashMap<String, Exclusion> exclusions = new HashMap<String, Exclusion>();
            for (Dependency depMgtDependency : depMgtDependencies) {
                depMgtMap.put(depMgtDependency.getManagementKey(), depMgtDependency);
                exclusions.putAll(this.addExclusions(depMgtDependency.getExclusions()));
            }
            HashSet<Artifact> allDependencyArtifacts = new HashSet<Artifact>(this.project.getArtifacts());
            if (this.ignoreDirect) {
                this.getLog().info((CharSequence)"\tIgnoring Direct Dependencies.");
                Set directDependencies = this.project.getDependencyArtifacts();
                allDependencyArtifacts.removeAll(directDependencies);
            }
            List<Artifact> exclusionErrors = this.getExclusionErrors(exclusions, allDependencyArtifacts);
            for (Artifact exclusion : exclusionErrors) {
                this.getLog().info((CharSequence)(StringUtils.stripEnd((String)this.getArtifactManagementKey(exclusion), (String)":") + " was excluded in DepMgt, but version " + exclusion.getVersion() + " has been found in the dependency tree."));
                foundError = true;
            }
            Map<Artifact, Dependency> mismatch = this.getMismatch(depMgtMap, allDependencyArtifacts);
            for (Map.Entry<Artifact, Dependency> entry : mismatch.entrySet()) {
                this.logMismatch(entry.getKey(), entry.getValue());
                foundError = true;
            }
            if (!foundError) {
                this.getLog().info((CharSequence)"   None");
            }
        } else {
            this.getLog().info((CharSequence)"   Nothing in DepMgt.");
        }
        return foundError;
    }

    public Map<String, Exclusion> addExclusions(List<Exclusion> exclusionList) {
        HashMap<String, Exclusion> exclusions = new HashMap<String, Exclusion>();
        if (exclusionList != null) {
            for (Exclusion exclusion : exclusionList) {
                exclusions.put(this.getExclusionKey(exclusion), exclusion);
            }
        }
        return exclusions;
    }

    public List<Artifact> getExclusionErrors(Map<String, Exclusion> exclusions, Set<Artifact> allDependencyArtifacts) {
        ArrayList<Artifact> list = new ArrayList<Artifact>();
        for (Artifact artifact : allDependencyArtifacts) {
            if (!exclusions.containsKey(this.getExclusionKey(artifact))) continue;
            list.add(artifact);
        }
        return list;
    }

    public String getExclusionKey(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId();
    }

    public String getExclusionKey(Exclusion ex) {
        return ex.getGroupId() + ":" + ex.getArtifactId();
    }

    public Map<Artifact, Dependency> getMismatch(Map<String, Dependency> depMgtMap, Set<Artifact> allDependencyArtifacts) {
        HashMap<Artifact, Dependency> mismatchMap = new HashMap<Artifact, Dependency>();
        for (Artifact dependencyArtifact : allDependencyArtifacts) {
            Dependency depFromDepMgt = depMgtMap.get(this.getArtifactManagementKey(dependencyArtifact));
            if (depFromDepMgt == null) continue;
            dependencyArtifact.isSnapshot();
            if (depFromDepMgt.getVersion().equals(dependencyArtifact.getBaseVersion())) continue;
            mismatchMap.put(dependencyArtifact, depFromDepMgt);
        }
        return mismatchMap;
    }

    public void logMismatch(Artifact dependencyArtifact, Dependency dependencyFromDepMgt) throws MojoExecutionException {
        if (dependencyArtifact == null || dependencyFromDepMgt == null) {
            throw new MojoExecutionException("Invalid params: Artifact:" + dependencyArtifact + " Dependency:" + dependencyFromDepMgt);
        }
        this.getLog().info((CharSequence)("\tDependency: " + StringUtils.stripEnd((String)dependencyFromDepMgt.getManagementKey(), (String)":")));
        this.getLog().info((CharSequence)("\t\tDepMgt  : " + dependencyFromDepMgt.getVersion()));
        this.getLog().info((CharSequence)("\t\tResolved: " + dependencyArtifact.getBaseVersion()));
    }

    public String getArtifactManagementKey(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getType() + (artifact.getClassifier() != null ? ":" + artifact.getClassifier() : "");
    }

    public boolean isFailBuild() {
        return this.failBuild;
    }

    public void setFailBuild(boolean theFailBuild) {
        this.failBuild = theFailBuild;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject theProject) {
        this.project = theProject;
    }

    public boolean isIgnoreDirect() {
        return this.ignoreDirect;
    }

    public void setIgnoreDirect(boolean theIgnoreDirect) {
        this.ignoreDirect = theIgnoreDirect;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }
}

