/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.manager;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.mojo.natives.compiler.Compiler;
import org.codehaus.mojo.natives.manager.CompilerManager;
import org.codehaus.mojo.natives.manager.NoSuchNativeProviderException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;

@Component(role=CompilerManager.class, hint="native-compiler-provider-manager")
public class DefaultCompilerManager
extends AbstractLogEnabled
implements CompilerManager,
Initializable {
    @Requirement(role=Compiler.class)
    private Map<String, Compiler> providers;

    public void initialize() {
        if (this.providers == null) {
            this.providers = new HashMap<String, Compiler>();
        }
        if (this.providers.size() == 0) {
            this.getLogger().warn("No compiler providers configured.");
        }
    }

    @Override
    public Compiler getCompiler(String providerType) throws NoSuchNativeProviderException {
        Compiler provider = this.providers.get(providerType);
        if (provider == null) {
            throw new NoSuchNativeProviderException(providerType);
        }
        return provider;
    }
}

