;;
;; Copyright (c) 2002 by The XFree86 Project, Inc.
;;
;; Permission is hereby granted, free of charge, to any person obtaining a
;; copy of this software and associated documentation files (the "Software"),
;; to deal in the Software without restriction, including without limitation
;; the rights to use, copy, modify, merge, publish, distribute, sublicense,
;; and/or sell copies of the Software, and to permit persons to whom the
;; Software is furnished to do so, subject to the following conditions:
;;
;; The above copyright notice and this permission notice shall be included in
;; all copies or substantial portions of the Software.
;;
;; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
;; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
;; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
;; THE XFREE86 PROJECT BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
;; WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
;; OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
;; SOFTWARE.
;;
;; Except as contained in this notice, the name of the XFree86 Project shall
;; not be used in advertising or otherwise to promote the sale, use or other
;; dealings in this Software without prior written authorization from the
;; XFree86 Project.
;;
;; Author: Paulo César Pereira de Andrade
;;
;;
;; $XFree86: xc/programs/xedit/lisp/test/math.lsp,v 1.4 2002/11/30 23:13:14 paulo Exp $
;;

;; basic math tests
;; This is far from a good regression test, but in the current stage of
;; the interpreter, this is good enough to make sure it is not "so"
;; broken. But note that this does not test all cases where there is
;; change in the type of a numeric object.

(setq *default-float-format* 'double-float)

;; floating point results may differ from implementation to implementation (?!)

(defun test (expect function &rest arguments &aux result (error t))
    (ignore-errors
	(setq result (apply function arguments))
	(setq error nil)
    )
    (if error
	(format t "ERROR: (~A~{ ~A~})~%" function arguments)
	;; Use eql to make sure result and expect have the same type
	(or (eql result expect)
#-xedit	;; hack...
	    (or
		(and
		    (floatp result)
		    (floatp expect)
		    (< (abs (- (abs result) (abs expect)))
			0.00000000000001d0)
		)
		(format t "(~A~{ ~A~}) => should be ~A not ~A~%"
		    function arguments expect result
		)
	    )
#+xedit     (format t "(~A~{ ~A~}) => should be ~A not ~A~%"
		function arguments expect result
	    )
	)
    )
)

(defun div-test (quotient remainder function &rest arguments
		 &aux quo rem  (error t))
    (ignore-errors
	(multiple-value-setq (quo rem) (apply function arguments))
	(setq error nil)
    )
    (if error
	(format t "ERROR: (~A~{ ~A~})~%" function arguments)
	(or (and (eql quotient quo) (eql remainder rem))
#-xedit	;; hack
	    (or
		(or
		    (eql quotient quo)
		    (and
			(floatp quotient)
			(floatp quo)
			(< (abs (- (abs quotient) (abs quo)))
			    0.00000000000001d0)
		    )
		)
		(or
		    (eql remainder rem)
		    (and
			(floatp remainder)
			(floatp rem)
			(< (abs (- (abs remainder) (abs rem)))
			    0.00000000000001d0)
		    )
		)
		(format t "(~A~{ ~A~}) => should be ~A; ~A not ~A; ~A~%"
		    function arguments quotient remainder quo rem
		)
	    )
#+xedit	    (format t "(~A~{ ~A~}) => should be ~A; ~A not ~A; ~A~%"
		function arguments quotient remainder quo rem
	    )
	)
    )
)

(defun bool-test (expect function &rest arguments &aux result (error t))
    (ignore-errors
	(setq result (apply function arguments))
	(setq error nil)
    )
    (if error
	(format t "ERROR: (~A~{ ~A~})~%" function arguments)
	(or (eq result expect)
	    (format t "(~A~{ ~A~}) => should be ~A not ~A~%"
		function arguments expect result
	    )
	)
    )
)

(defun error-test (function &rest arguments &aux result (error t))
  (ignore-errors
    (setq result (apply function arguments))
    (setq error nil))
  (unless error
    (format t "ERROR: no error for (~A~{ ~A}), result was ~A~%"
      function arguments result)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; fixnum fixnum
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(test 0 #'+)
(test 5 #'+ 5)
(test -2 #'+ -2)
(test 3 #'+ 2 1)
(test 134217728 #'+ 134217727 1)
(test -134217729 #'+ -134217728 -1)
(test 2147483648 #'+ 2147483647 1)
(test -2147483649 #'+ -2147483648 -1)
(test -5 #'- 5)
(test 6 #'- -6)
(test 1 #'- 2 1)
(test 134217728 #'- 134217727 -1)
(test -2147483649 #'- -2147483648 1)
(test 4294967295 #'- 2147483647 -2147483648)
(test 1 #'*)
(test 4 #'* 4)
(test -5 #'* -5)
(test 6 #'* 2 3)
(test 2147483648 #'* 65536 32768)
(test 2147418112 #'* 65536 32767)
(test 134217728 #'* 65536 2048)
(test -134217728 #'* 65536 -2048)
(test 1/3 #'/ 3)
(test -1/4 #'/ -4)
(test 1/3 #'/ 10 30)
(test -1/2 #'/ -5 10)
(test -4 #'/ 20 -5)
(test 431432412345/32 #'/ 431432412345 32)
(test -2147483647/2147483648 #'/ 2147483647 -2147483648)
(test -1 #'/ 2147483648 -2147483648)
(test 2147483648 #'/ -2147483648 -1)
(test -1/2147483648 #'/ 1 -2147483648)
(test 1 #'min 2 3 4 1 5)
(test 7 #'max 0 -2 7 6 3)
(test -2147483648 #'min -2147483648 2147483647)
(test 2147483647 #'max -2147483648 2147483647)
(bool-test t #'< 1 2)
(bool-test nil #'< 2 2)
(bool-test nil #'< 4 3)
(bool-test t #'< -2147483648 -1)
(bool-test t #'< -2147483648 2147483648)
(bool-test t #'<= 3 3)
(bool-test nil #'<= 3 2)
(bool-test t #'<= 3 7)
(bool-test t #'<= -2147483648 2147483648)
(bool-test t #'= 1 1)
(bool-test nil #'= 1 -1)
(bool-test t #'= -2147483648 -2147483648)
(bool-test t #'>= 4 3)
(bool-test t #'>= 5 5)
(bool-test nil #'>= 4 9)
(bool-test t #'>= 2147483647 -2147483648)
(bool-test t #'> 7 5)
(bool-test nil #'> 20 20)
(bool-test nil #'> 19 31)
(bool-test nil #'> 2147483647 2147483648)
(bool-test nil #'> -2147483648 2147483647)
(bool-test nil #'/= 2147483647 2147483647)
(bool-test t #'/= 2147483647 -2147483648)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; fixnum bignum
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(test 4123412341238575768576858308380 #'+
	431412 4123412341238575768576857876968)
(test -653653534554686349560628211 #'-
	4231423 653653534554686349564859634)
(test 17952112630025927929 #'* 4342423 4134123421423)
(test 412341/766687896595678 #'/ 412341 766687896595678)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; fixnum flonum
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(test 566594.4123d0 #'+ 43141 523453.4123d0)
(test -2.106249523586876d9 #'+ -2147483647 41234123.413124d0)
(test -6530250.653d0 #'- 4314 6534564.653d0)
(test -358687.653d0 #'- -324123 34564.653d0)
(test 3.26338916904d67 #'* 431234 756756d56)
(test 5.731169192902366d-50 #'/ 3 5234534d43)
(bool-test t #'< 423421 646454d0)
(bool-test t #'= 43242113 43242113d0)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; fixnum fixratio
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(test 38654705646/17 #'+ 2147483647 2147483647/17)
(test -2146748499/17 #'+ 43244 -2147483647/17)
(test 17633127/4232 #'- 4321 653345/4232)
(test 28227714415090/4323 #'* 4312442 6545645/4323)
(test 639030/1441 #'* 42 15215/1441)
(test 924444112/547 #'/ 3432342 1641/808)
(bool-test t #'> 41342 42423/32)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; fixnum bigratio
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(test 134681902103055335/31231131234 #'+ 4312423 53453535353/31231131234)
(test 134681795195984629/31231131234 #'- 4312423 53453535353/31231131234)
(test 230514255287590319/31231131234 #'* 4312423 53453535353/31231131234)
(test 134681848649519982/53453535353 #'/ 4312423 53453535353/31231131234)
(bool-test t #'> 4312423 53453535353/31231131234)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; bignum fixnum
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(test 4123412341234124068 #'+ 4123412341234123412 656)
(test 2147483647 #'+ 2147483648 -1)
(test 2147483648 #'- 2147483647 -1)
(test 3245393337480 #'* 4242344232 765)
(test 1414114744/255 #'/ 4242344232 765)
(bool-test nil #'< 2147483648 1)
(bool-test t #'> 2147483648 -2147483648)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; bignum flonum
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(test 5.452523543454353d15 #'+ 5452523543454353 423d-6)
(test -3.41423d205 #'- 54235423452345424443423 341423d200)
(test 2.7061221650759596d89 #'* 413423412341231232 6.545643242d71)
(test 9.744908405310087d-29 #'/ 41341234214 4242342d32)
(bool-test t #'< 4314123412312341234123 4234242d46)
(bool-test nil #'> 42342342142142421412341242 423423.432423d51)
(bool-test t #'= 100000000000000000000 1d20)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; bignum fixratio
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(test 3027180466416641662/7 #'+ 432454352345234523 1/7)
(test 4294967295/2 #'- 2147483648 1/2)
(test 14113747078041141/152263 #'* 42341241234123423 1/456789)
(test 475355357536664/19 #'* 43214123412424 11/19)
(test 143960192608 #'/ 4234123312 1/34)
(test 15032385536/5 #'/ 2147483648 5/7)
(bool-test nil #'< 4123412341234123 423424/23)
(bool-test nil #'= 2147483648 1/3)
(bool-test t #'> 2147483648 1/3)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; bignum bigratio
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(test -493153721444554600746963362777609/11404707804137
	#'+ -43241241241241234234 18178448448449/11404707804137)
(test 22573725350444837506376255369215081106984960/431241324242143434377
	#'- 52345923457394857234895 455/431241324242143434377)
(test 355905909219316970540364021939287762325439304380984344811607132990/14374707710807
	#'* 45523452345234790345923405723902389345782390 23454234524234523623623/43124123132421)
(test -853356237922877963618542794532291751029677352/21566206170617061706171
	#'/ 4131234123412342 -43132412341234123412342/413124123412312234123412312312)
(bool-test nil #'< 9482384762389461234892 463124869123897/43124123456678)
(bool-test t #'/= 4689123469123846123843 4123894623894612/211)
(bool-test t #'> 90437849234701234891203 4234123423/37)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; flonum fixnum
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(test 4.3291328479d86 #'+ 43291328479d76 431243)
(test 4.123123123432d58 #'- 4123123123432d46 2147483647)
(test 4.1974800714094d109 #'* 970874791d96 43234)
(test -1.0004838618250252d55 #'/ -432423.432d56 4322143)
(bool-test nil #'< 4324932.342d5 4321421)
(bool-test t #'> 2147483648d0 2147483647)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; flonum bignum
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(test 4.3124325345d62 #'+ 4312432.5345d56 431241234901234791023479023)
(test 4.123123443242d39 #'- 41231234.43242d32 -10947390284720389)
(test 9.81681448753991d48 #'* 42342.89d27 231840917980324712)
(test 6.837110051466236d49 #'/ -64832d57 -948236894126)
(bool-test nil #'< 7589079203d56 43214124124312)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; flonum flonum
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(test 4.12685643412d7 #'+ 34442.3412d0 41234122d0)
(test -4.23432d84 #'- -45523453d56 423432d79)
(test 2.0000000000000004d0 #'* 1.4142135623730951d0 1.4142135623730951d0)
(test -1.414213562373095d0 #'/ -2d0 1.4142135623730951d0)
(test 0.7071067811865476d0 #'/ 1.4142135623730951d0 2d0)
(bool-test nil #'< 43124123d56 4231412d43)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; flonum fixratio
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(test 3.41412d61 #'+ 341412d56 3/652)
(test 4.312443d72 #'- 43124.43d68 42421/5678)
(test -4.32112300201218d73 #'* 4321123d67 -2147483648/2147483647)
(test 3.388443859138533d58 #'/ 432412d54 13744/1077)
(bool-test t #'> 423194237d43 4231412/23)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; flonum bigratio
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(test 4.378904431d62 #'+ 4378904.431d56 49230471923047129/32412341234126)
(test 0d0 #'- 1.7320508075688772d0 3900231685776981/2251799813685248)
(test 5.000000000000001d0 #'* 2.23606797749979d0 629397181890197/281474976710656)
(test 7.000000000000001d0 #'/ 2.6457513110645907d0 1125899906842624/2978851154656373)
(bool-test nil #'< 790412390412d45 1005712007432/10518078881)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; fixratio fixnum
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(test 23502480199/57 #'+ 1/57 412324214)
(test -1608505/39 #'- 11/39 41244) 
(test 241844976595/3121 #'* 45245/3121 5345231)
(test 4231/30211050 #'/ 4231/67890 445)
(bool-test nil #'< 43123/12 -3432)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; fixratio bignum
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(test 290071443963580821646/4115 #'+ -14119/4115 70491237901234711)
(test 92654360215843653827434431256/1237 #'- 423412/1237 -74902473901247901234789012)
(test 139081825032265225396/111 #'* 13/777 74890213478912044444)
(test -22/19000187487170108051697772680759 #'/ -176/31 4903274190237447239147812304712)
(bool-test t #'< 7094123/312 423412429047)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; fixratio flonum
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(test 3756.777956289953d0 #'+ 41290/11 3.141592653589793d0)
(test 3750.494770982774d0 #'- 41290/11 3.141592653589793d0)
(test 11792.396424247505d0 #'* 41290/11 3.141592653589793d0)
(test 1194.8195636844289d0 #'/ 41290/11 3.141592653589793d0)
(bool-test nil #'< 41290/11 3.141592653589793d0)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; fixratio fixratio
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(test -2/2147483647 #'+ 2147483646/2147483647 -2147483648/2147483647)
(test 4611686015206162432/2305843005992468481 #'+ 2147483648/2147483646 2147483648/2147483647)
(test 114/91 #'+ 5/7 7/13)
(test 2 #'- 2147483646/2147483647 -2147483648/2147483647)
(test -6442450939/4611686009837453315 #'- 2147483646/2147483647 2147483647/2147483645)
(test 214/231 #'- 5/7 -7/33)
(test 183092240452/408559 #'* '432421/3217 423412/127)
(test 1057751/7345 #'* 34121/65 31/113)
(test -93866791/102381559 #'/ 143747/107 -956837/653)
(test 117/517 #'/ 13/33 47/27)
(bool-test nil #'< 5/3 7/9)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; fixratio bigratio
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(test 1211321073398067249731082729214954013/1099249926163926018396018404101914
	#'+ 23141/21 572903572390457239/52345234579234572304572304957234)
(test -1210401943424090457832980748892408320175/1099249926163926018396018404101914
	#'+ -23123441/21 572903572390457239/52345234579234572304572304957234)
(test -130565585970579643613431728982140/1297324236427391
	#'- 6/83 1573079349043128237436315709694/15630412487077)
(test 119377824848653/98027 #'* 4123/61 28954117111/1607)
(test -533081148/1126543487854337661125 #'/ 4132412/125 -9012347902834701289/129)
(bool-test nil #'< 4132412/125 -9012347902834701289/129)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; bigratio fixnum
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(test 48668779872364438/8438103123 #'+ 49032749012471920/8438103123 -43134)
(test 49396718152579402/8438103123 #'- 49032749012471920/8438103123 -43134)
(test -704992865301321265760/2812701041 #'* 49032749012471920/8438103123 -43134)
(test -24516374506235960/181984570053741 #'/ 49032749012471920/8438103123 -43134)
(bool-test t #'> 49032749012471920/8438103123 -43134)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; bigratio bignum
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(test 22765322736543569109219273030163417097453878379283263605274270/46382946123894712341
	#'+ 4692318468912374612389461278/46382946123894712341 490812348912346238794612389461238961238912)
(test -22765322736543569109219273030163417097453878379283263605274270/46382946123894712341
	#'- -4692318468912374612389461278/46382946123894712341 490812348912346238794612389461238961238912)
(test -2303047849571666696101160700266058250647016644840659232609643130849536/46382946123894712341
	#'* 4692318468912374612389461278/46382946123894712341 -490812348912346238794612389461238961238912)
(test 2346159234456187306194730639/11382661368271784554609636515081706202567704733454325607906496
	#'/ -4692318468912374612389461278/46382946123894712341 -490812348912346238794612389461238961238912)
(bool-test t #'< 4692318468912374612389461278/46382946123894712341 490812348912346238794612389461238961238912)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; bigratio flonum
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(test 63.2771680782255d0 #'+ 31.63858403911275d0 4452734852783697/140737488355328)
(test 0d0 #'+ -31.63858403911275d0 4452734852783697/140737488355328)
(test -1001.0000000000001d0 #'* -31.63858403911275d0 4452734852783697/140737488355328)
(test 1d0 #'/ -31.63858403911275d0 -4452734852783697/140737488355328)
(bool-test nil #'< -31.63858403911275d0 -4452734852783697/140737488355328)
(bool-test nil #'> -31.63858403911275d0 -4452734852783697/140737488355328)
(bool-test nil #'/= -31.63858403911275d0 -4452734852783697/140737488355328)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; bigratio fixratio
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(test 0 #'+ 2147483648/2147483647 -2147483648/2147483647)
(test 3230093924913437/413416372043776 #'+ 45705840067699/8796093022208 123/47)
(test 4294967296/2147483647 #'- 2147483648/2147483647 -2147483648/2147483647)
(test 1066255041450269/413416372043776 #'- 45705840067699/8796093022208 123/47)
(test -5621818328326977/413416372043776 #'* -45705840067699/8796093022208 123/47)
(test -2148174483181853/1081919441731584 #'/ 45705840067699/8796093022208 -123/47)
(bool-test t #'> 45705840067699/8796093022208 123/47)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; bigratio bigratio
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(test 2679495973598190955776211861634126560767052764822779809414184089582/140710542183009389719255843429922029722593
	#'+ 649812364891236481923461238946128/34124123 -7489023423142/4123491823746192384761238946123891)
(test 2679495973598190955776211861634126560767052765333892522296541398514/140710542183009389719255843429922029722593
	#'- 649812364891236481923461238946128/34124123 -7489023423142/4123491823746192384761238946123891)
(test -4866460021317766216371472892133283923086494176/140710542183009389719255843429922029722593
	#'* 649812364891236481923461238946128/34124123 -7489023423142/4123491823746192384761238946123891)
(test -1339747986799095477888105930817063280383526382539168082927681372024/127778178220589327233
	#'/ 649812364891236481923461238946128/34124123 -7489023423142/4123491823746192384761238946123891)
(bool-test t #'> 649812364891236481923461238946128/34124123 -7489023423142/4123491823746192384761238946123891)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; complex real
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(test #c(2147483648 -1) #'+ #c(1 -1) 2147483647)
(test #c(2.147483648d9 -1) #'+ #c(2147483647 -1) 1d0)
(test #c(129642370237029633787/3 0.25d0) #'- #c(-11/3 0.25d0) -43214123412343211266)
(test #c(23470/21 4.333333333333334d0) #'* #c(2347/7 1.3d0) 10/3)
(test #c(134217728/11 67108864/11) #'* #c(65536 32768) 2048/11)
(test #c(1.3133333333333332d0 82304) #'/ #c(1.97d0 123456) 3/2)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; real complex
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(test #c(80/7 7/13) #'+ 3/7 #c(11 7/13))
(test #c(1.2345d47 -1) #'+ 12345d43 #c(-2147483648 -1))
(test #c(-2147483649 2147483647) #'+ -2147483648 #c(-1 2147483647))
(test #c(41/15 1.23456d68) #'- #c(7/5 1234.56d65) -4/3)
(test #c(-41/19 2147483648) #'* #c(41/19 -2147483648) -1)
(test #c(-88046829568/40802189293 2.147483649d41) #'* #c(41/19 -2147483648d32) -2147483648/2147483647)
(test #c(-5.0691244239631335d0 1.3911008563333336d16)
	#'/ #c(-11/7 4312412654633334) 0.31d0)
(bool-test t #'= #c(1 0.0) 1)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; complex complex
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(test #c(-16.0d0 -4.0d0) #'+ #c(-16.0d0 -4.0d0))
(test #c(0d0 1d0) #'- #c(0d0 -1d0))
(test #c(1d0 3d0) #'- #c(-1d0 -3d0))
(test #c(-16.0d0 -4.0d0) #'* #c(-16.0d0 -4.0d0))
(test #c(-0.058823529411764705d0 0.014705882352941176d0) #'/ #c(-16d0 -4d0))
(test #c(1.94d0 301868863889/7) #'+ #c(3/5 5/7) #c(1.34d0 43124123412))
(test #c(8641975242/7 -3.4596d0) #'- #c(1234567890 0.0004d0) #c(-12/7 3.46d0))
(test #c(2944.315858312371d0 5.59002d13) #'* #c(-11/7 -1234d9) #c(-45.3d0 5/2147483647))
(test #c(1.9635384272224412d-8 -0.33333333317811176d0)
	#'/ #c(2147483647/3 -0.5d0) #c(128 2147483648.0d0))
(test #c(8.154945137073864d11 2.621232365490813d12)
	#'/ #c(-1.3d0 4312412654633) #c(3/2 7/15))
(test #c(0.003674737027278924d0 -257.6948748113586d0)
	#'/ #c(1.5d0 -432412) #c(1678 -567/31313))
(bool-test t #'= #c(1 2d0) #c(1 2))
(bool-test nil #'/= #c(1 2) #c(1d0 2d0))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; abs
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(test 2147483648 #'abs -2147483648)
(test 2147483647 #'abs -2147483647)
(test 2147483647 #'abs 2147483647)
(test 1 #'abs 1)
(test 5/7 #'abs -5/7)
(test 2147483648/2147483647 #'abs -2147483648/2147483647)
(test 3.12d0 #'abs -3.12d0)
(test 4312412341234124124123412 #'abs 4312412341234124124123412)
(test 4312412341234124124123412 #'abs -4312412341234124124123412)
(test 1.0 #'abs #c(1 0.0))
(test 11.40175425099138d0 #'abs #c(-11 3d0))
(test 4.47213595499958d0 #'abs #c(-4 -2))
(test 1.0 #'abs #c(0.0 -1.0))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; sqrt
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(test 3.4641016151377544d0 #'sqrt 12)
(test #c(0 12) #'sqrt -144)
(test 6.429728792199102d18 #'sqrt 41341412341234123412490123470912347210)
(test 41341412341234123412490123470912347210
	#'sqrt 1709112374367945085349927261774254951456404621200206927501652414831594784100)
(test 46340.95001184158d0 #'sqrt 2147483648)
(test 0.7071067811865476d0 #'sqrt 0.5d0)
(test 0 #'sqrt 0)
(test 0d0 #'sqrt 0d0)
(test 111.1106106544285d0 #'sqrt 12345.5678d0)
(test #c(0 11.119982014373944d0) #'sqrt -123.654d0)
(test 3/8 #'sqrt 9/64)
(test #c(0 1.1832159566199232d0) #'sqrt -7/5)
(test 514.7536007118473d0 #'sqrt 821974900428408092/3102128401119)
(test 413412341293461238946192384612893/314212341412341246128361289
	#'sqrt 170909763933741276657131032282211169869649489782500833989461829449/98729395495825697643724477479624921705328808513741521)
;; check for overflow
(error-test #'sqrt 402387260077093773543702433923003985719374864210714632543799910429938512398629020592044208486969404800479988610197196058631666872994808558901323829669944590997424504087073759918823627727188732519779505950995276120874975462497043601418278094646496291056393887437886487337119181045825783647849977012476632889835955735432513185323958463075557409114262417474349347553428646576611667797396668820291207379143853719588249808126867838374559731746136085379534524221586593201928090878297308431392844403281231558611036976801357304216168747609675871348312025478589320767169132448426236131412508780208000261683151027341827977704784635868170164365024153691398281264810213092761244896359928705114964975419909342221566832572080821333186116811553615836546984046708975602900950537616475847728421889679646244945160765353408198901385442487984959953319101723355556602139450399736280750137837615307127761926849034352625200015888535147331611702103968175921510907788019393178114194545257223865541461062892187960223838971476088506276862967146674697562911234082439208160153780889893964518263243671616762179168909779911903754031274622289988005195444414282012187361745992642956581746628302955570299024324153181617210465832036786906117260158783520751516284225540265170483304226143974286933061690897968482590125458327168226458066526769958652682272807075781391858178889652208164348344825993266043367660176999612831860788386150279465955131156552036093988180612138558600301435694527224206344631797460594682573103790084024432438465657245014402821885252470935190620929023136493273497565513958720559654228749774011413346962715422845862377387538230483865688976461927383814900140767310446640259899490222221765904339901886018566526485061799702356193897017860040811889729918311021171229845901641921068884387121855646124960798722908519296819372388642614839657382291123125024186649353143970137428531926649875337218940694281434118520158014123344828015051399694290153483077644569099073152433278288269864602789864321139083506217095002597389863554277196742822248757586765752344220207573630569498825087968928162753848863396909959826280956121450994871701244516461260379029309120889086942028510640182154399457156805941872748998094254742173582401063677404595741785160829230135358081840096996372524230560855903700624271243416909004153690105933983835777939410970027753472000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; mod
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(test 5 #'mod 5 9)
(test 4 #'mod -5 9)
(test -4 #'mod 5 -9)
(test -5 #'mod -5 -9)
(test 2147483646 #'mod -2147483648 2147483647)
(test -1 #'mod -2147483648 -2147483647)
(test 1 #'mod 2147483648 2147483647)
(test 0 #'mod -170909763933741276657131032282211169869649489782500833989461829449 413412341293461238946192384612893)
(test -1709112374367945085349927261774254951415063208858972804089162291360682436890
	#'mod 41341412341234123412490123470912347210 -1709112374367945085349927261774254951456404621200206927501652414831594784100)
(test 9.666666666666666d0 #'mod -1/3 10d0)
(test -9.666666666666666d0 #'mod 1/3 -10d0)
(test -0.3333333333333333d0 #'mod -1/3 -10d0)
(test 0.3333333333333333d0 #'mod 1/3 10d0)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; rem
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(test 2 #'rem 11 3)
(test 2 #'rem 11 -3)
(test -2 #'rem -11 3)
(test -2 #'rem -11 -3)
(test -1 #'rem -2147483648 2147483647)
(test  0.1499999999999999d0 #'rem 1.35d0 1/5)
(test  -0.1499999999999999d0 #'rem -1.35d0 1/5)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; gcd
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(test 11 #'gcd 33 11)
(test 7 #'gcd 91 -49)
(test 4 #'gcd -4)
(test 0 #'gcd)
(test 11 #'gcd 3333 -33 1002001)
(test 1 #'gcd -2147483648 2147483647)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; lcm
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(test 1 #'lcm)
(test 10 #'lcm 10)
(test 5 #'lcm -5)
(test 4611686016279904256 #'lcm -2147483648 2147483647)
(test 0 #'lcm 0 5)
(test 60 #'lcm 1 2 3 4 5 6)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; and
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(test -1 #'logand)
(test 0 #'logand 1 2)
(test -2147483648 #'logand -2147483648 -1)
(test 2147483647 #'logand 2147483647 -1)
(test 2147479552 #'logand 8796093018112 2147483647)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; eqv
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(test -1 #'logeqv)
(test -4 #'logeqv 1 2)
(test -2147483648 #'logeqv -2147483648 -1)
(test 2147483647 #'logeqv 2147483647 -1)
(test -8793945542656 #'logeqv 8796093018112 2147483647)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; or
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(test 0 #'logior)
(test 3 #'logior 1 2)
(test -1 #'logior -2147483648 -1)
(test -1 #'logior 2147483647 -1)
(test 8796093022207 #'logior 8796093018112 2147483647)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; xor
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(test 0 #'logxor)
(test 3 #'logxor 1 2)
(test 2147483647 #'logxor -2147483648 -1)
(test -2147483648 #'logxor 2147483647 -1)
(test 8793945542655 #'logxor 8796093018112 2147483647)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; not
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(test -1 #'lognot 0)
(test 0 #'lognot -1)
(test -2 #'lognot 1)
(test 1 #'lognot -2)
(test -3 #'lognot 2)
(test 2 #'lognot -3)
(test -2147483648 #'lognot 2147483647)
(test 2147483647 #'lognot -2147483648)
(test -8793945542656 #'lognot 8793945542655)
(test -8796093018113 #'lognot 8796093018112)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; floor
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(div-test 1 1/2 #'floor 3/2)
(div-test 1d0 1 #'ffloor 3 2)
(div-test -2 2147483646 #'floor -2147483648 2147483647)
(div-test 2147483648 0 #'floor -2147483648 -1)
(div-test 17179869184 0 #'floor 18446744073709551616 1073741824)
(div-test -17179869201 -1073741807 #'floor 18446744073709551616 -1073741823)
(div-test 2147483648 0d0 #'floor -2147483648 -1d0)
(div-test -2 2147483646/2147483647 #'floor -2147483648/2147483647)
(div-test 32768 32768/2147483647 #'floor 2147483648/2147483647 65535/2147483647)
(div-test -32769 -32767/2147483647 #'floor 2147483648/2147483647 -65535/2147483647)
(div-test -32769 32767/2147483647 #'floor -2147483648/2147483647 65535/2147483647)
(div-test 32768 -32768/2147483647 #'floor -2147483648/2147483647 -65535/2147483647)
(div-test 2 0.5d0 #'floor 3d0 1.25d0)
(div-test 2 1d0 #'floor 4d0 1.5d0)
(div-test -3 -0.5d0 #'floor 4d0 -1.5d0)
(div-test -3 0.5d0 #'floor -4d0 1.5d0)
(div-test 2 -1d0 #'floor -4d0 -1.5d0)
(div-test 1 2/91 #'floor 5/7 9/13)
(div-test -2 -61/91 #'floor 5/7 -9/13)
(div-test -2 61/91 #'floor -5/7 9/13)
(div-test 1 -2/91 #'floor -5/7 -9/13)
(div-test 1 0 #'floor 2147483648/2147483647 2147483648/2147483647)
(div-test -1 0 #'floor 2147483648/2147483647 -2147483648/2147483647)
(div-test -1 0 #'floor -2147483648/2147483647 2147483648/2147483647)
(div-test 1 0 #'floor -2147483648/2147483647 -2147483648/2147483647)
(div-test 9437 1416337955817765/144137437447079
	#'floor 16324116304212832041/144137437447079 12)
(div-test -9438 -313311293547183/144137437447079
	#'floor 16324116304212832041/144137437447079 -12)
(div-test -9438 313311293547183/144137437447079
	#'floor -16324116304212832041/144137437447079 12)
(div-test 9437 -1416337955817765/144137437447079
	#'floor -16324116304212832041/144137437447079 -12)
(div-test 8081 1138147903718848755797/4324123123412370
	#'floor 2147483648 1148972348912638496123/4324123123412370)
(div-test -8082 -1804074198964956721/720687187235395
	#'floor 2147483648 -1148972348912638496123/4324123123412370)
(div-test -8082 1804074198964956721/720687187235395
	#'floor -2147483648 1148972348912638496123/4324123123412370)
(div-test 8081 -1138147903718848755797/4324123123412370
	#'floor -2147483648 -1148972348912638496123/4324123123412370)
(div-test 0 1148972348912638496123/4324123123412370111
	#'floor 1148972348912638496123/4324123123412370111 2147483648)
(div-test -1 -9285982550494401861657948805/4324123123412370111
	#'floor 1148972348912638496123/4324123123412370111 -2147483648)
(div-test -1 9285982550494401861657948805/4324123123412370111
	#'floor -1148972348912638496123/4324123123412370111 2147483648)
(div-test 0 -1148972348912638496123/4324123123412370111
	#'floor -1148972348912638496123/4324123123412370111 -2147483648)
(div-test 0.0d0 1.0000000004656613d0 #'ffloor 2147483648/2147483647 2147483648d0)
(div-test -1.0d0 -2.147483647d9 #'ffloor 2147483648/2147483647 -2147483648d0)
(div-test -1.0d0 2.147483647d9 #'ffloor -2147483648/2147483647 2147483648d0)
(div-test 0.0d0 -1.0000000004656613d0 #'ffloor -2147483648/2147483647 -2147483648d0)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; ceiling
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(div-test 2 -1/2 #'ceiling 3/2)
(div-test 2d0 -1 #'fceiling 3 2)
(div-test -1 -1 #'ceiling -2147483648 2147483647)
(div-test 2147483648 0 #'ceiling -2147483648 -1)
(div-test 17179869184 0 #'ceiling 18446744073709551616 1073741824)
(div-test -17179869200 16 #'ceiling 18446744073709551616 -1073741823)
(div-test 2147483648 0d0 #'ceiling -2147483648 -1d0)
(div-test -1 -1/2147483647 #'ceiling -2147483648/2147483647)
(div-test 32769 -32767/2147483647 #'ceiling 2147483648/2147483647 65535/2147483647)
(div-test -32768 32768/2147483647 #'ceiling 2147483648/2147483647 -65535/2147483647)
(div-test -32768 -32768/2147483647 #'ceiling -2147483648/2147483647 65535/2147483647)
(div-test 32769 32767/2147483647 #'ceiling -2147483648/2147483647 -65535/2147483647)
(div-test 3 -0.75d0 #'ceiling 3d0 1.25d0)
(div-test 3 -0.5d0 #'ceiling 4d0 1.5d0)
(div-test -2 1d0 #'ceiling 4d0 -1.5d0)
(div-test -2 -1d0 #'ceiling -4d0 1.5d0)
(div-test 3 0.5d0 #'ceiling -4d0 -1.5d0)
(div-test 2 -61/91 #'ceiling 5/7 9/13)
(div-test -1 2/91 #'ceiling 5/7 -9/13)
(div-test -1 -2/91 #'ceiling -5/7 9/13)
(div-test 2 61/91 #'ceiling -5/7 -9/13)
(div-test 1 0 #'ceiling 2147483648/2147483647 2147483648/2147483647)
(div-test -1 0 #'ceiling 2147483648/2147483647 -2147483648/2147483647)
(div-test -1 0 #'ceiling -2147483648/2147483647 2147483648/2147483647)
(div-test 1 0 #'ceiling -2147483648/2147483647 -2147483648/2147483647)
(div-test 9438 -313311293547183/144137437447079
	#'ceiling 16324116304212832041/144137437447079 12)
(div-test -9437 1416337955817765/144137437447079
	#'ceiling 16324116304212832041/144137437447079 -12)
(div-test -9437 -1416337955817765/144137437447079
	#'ceiling -16324116304212832041/144137437447079 12)
(div-test 9438 313311293547183/144137437447079
	#'ceiling -16324116304212832041/144137437447079 -12)
(div-test 8082 -1804074198964956721/720687187235395
	#'ceiling 2147483648 1148972348912638496123/4324123123412370)
(div-test -8081 1138147903718848755797/4324123123412370
	#'ceiling 2147483648 -1148972348912638496123/4324123123412370)
(div-test -8081 -1138147903718848755797/4324123123412370
	#'ceiling -2147483648 1148972348912638496123/4324123123412370)
(div-test 8082 1804074198964956721/720687187235395
	#'ceiling -2147483648 -1148972348912638496123/4324123123412370)
(div-test 1 -9285982550494401861657948805/4324123123412370111
	#'ceiling 1148972348912638496123/4324123123412370111 2147483648)
(div-test 0 1148972348912638496123/4324123123412370111
	#'ceiling 1148972348912638496123/4324123123412370111 -2147483648)
(div-test 0 -1148972348912638496123/4324123123412370111
	#'ceiling -1148972348912638496123/4324123123412370111 2147483648)
(div-test 1 9285982550494401861657948805/4324123123412370111
	#'ceiling -1148972348912638496123/4324123123412370111 -2147483648)
(div-test 1.0d0 -2.147483647d9 #'fceiling 2147483648/2147483647 2147483648d0)
(div-test 0d0 1.0000000004656613d0 #'fceiling 2147483648/2147483647 -2147483648d0)
(div-test 0d0 -1.0000000004656613d0 #'fceiling -2147483648/2147483647 2147483648d0)
(div-test 1d0 2.147483647d9 #'fceiling -2147483648/2147483647 -2147483648d0)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; truncate
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(div-test 1 1/2 #'truncate 3/2)
(div-test 1d0 1 #'ftruncate 3 2)
(div-test -1 -1 #'truncate -2147483648 2147483647)
(div-test 2147483648 0 #'truncate -2147483648 -1)
(div-test 17179869184 0 #'truncate 18446744073709551616 1073741824)
(div-test -17179869200 16 #'truncate 18446744073709551616 -1073741823)
(div-test 2147483648 0d0 #'truncate -2147483648 -1d0)
(div-test -1 -1/2147483647 #'truncate -2147483648/2147483647)
(div-test 32768 32768/2147483647 #'truncate 2147483648/2147483647 65535/2147483647)
(div-test -32768 32768/2147483647 #'truncate 2147483648/2147483647 -65535/2147483647)
(div-test -32768 -32768/2147483647 #'truncate -2147483648/2147483647 65535/2147483647)
(div-test 32768 -32768/2147483647 #'truncate -2147483648/2147483647 -65535/2147483647)
(div-test 2 0.5d0 #'truncate 3d0 1.25d0)
(div-test 2 1d0 #'truncate 4d0 1.5d0)
(div-test -2 1d0 #'truncate 4d0 -1.5d0)
(div-test -2 -1d0 #'truncate -4d0 1.5d0)
(div-test 2 -1d0 #'truncate -4d0 -1.5d0)
(div-test 1 2/91 #'truncate 5/7 9/13)
(div-test -1 2/91 #'truncate 5/7 -9/13)
(div-test -1 -2/91 #'truncate -5/7 9/13)
(div-test 1 -2/91 #'truncate -5/7 -9/13)
(div-test 1 0 #'truncate 2147483648/2147483647 2147483648/2147483647)
(div-test -1 0 #'truncate 2147483648/2147483647 -2147483648/2147483647)
(div-test -1 0 #'truncate -2147483648/2147483647 2147483648/2147483647)
(div-test 1 0 #'truncate -2147483648/2147483647 -2147483648/2147483647)
(div-test 9437 1416337955817765/144137437447079
	#'truncate 16324116304212832041/144137437447079 12)
(div-test -9437 1416337955817765/144137437447079
	#'truncate 16324116304212832041/144137437447079 -12)
(div-test -9437 -1416337955817765/144137437447079
	#'truncate -16324116304212832041/144137437447079 12)
(div-test 9437 -1416337955817765/144137437447079
	#'truncate -16324116304212832041/144137437447079 -12)
(div-test 8081 1138147903718848755797/4324123123412370
	#'truncate 2147483648 1148972348912638496123/4324123123412370)
(div-test -8081 1138147903718848755797/4324123123412370
	#'truncate 2147483648 -1148972348912638496123/4324123123412370)
(div-test -8081 -1138147903718848755797/4324123123412370
	#'truncate -2147483648 1148972348912638496123/4324123123412370)
(div-test 8081 -1138147903718848755797/4324123123412370
	#'truncate -2147483648 -1148972348912638496123/4324123123412370)
(div-test 0 1148972348912638496123/4324123123412370111
	#'truncate 1148972348912638496123/4324123123412370111 2147483648)
(div-test 0 1148972348912638496123/4324123123412370111
	#'truncate 1148972348912638496123/4324123123412370111 -2147483648)
(div-test 0 -1148972348912638496123/4324123123412370111
	#'truncate -1148972348912638496123/4324123123412370111 2147483648)
(div-test 0 -1148972348912638496123/4324123123412370111
	#'truncate -1148972348912638496123/4324123123412370111 -2147483648)
(div-test 0d0 1.0000000004656613d0 #'ftruncate 2147483648/2147483647 2147483648d0)
(div-test 0d0 1.0000000004656613d0 #'ftruncate 2147483648/2147483647 -2147483648d0)
(div-test 0d0 -1.0000000004656613d0 #'ftruncate -2147483648/2147483647 2147483648d0)
(div-test 0d0 -1.0000000004656613d0 #'ftruncate -2147483648/2147483647 -2147483648d0)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; round
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(div-test 2 -1/2 #'round 3/2)
(div-test 2d0 -1 #'fround 3 2)
(div-test -1 -1 #'round -2147483648 2147483647)
(div-test 2147483648 0 #'round -2147483648 -1)
(div-test 17179869184 0 #'round 18446744073709551616 1073741824)
(div-test -17179869200 16 #'round 18446744073709551616 -1073741823)
(div-test 2147483648 0d0 #'round -2147483648 -1d0)
(div-test -1 -1/2147483647 #'round -2147483648/2147483647)
(div-test 32769 -32767/2147483647 #'round 2147483648/2147483647 65535/2147483647)
(div-test -32769 -32767/2147483647 #'round 2147483648/2147483647 -65535/2147483647)
(div-test -32769 32767/2147483647 #'round -2147483648/2147483647 65535/2147483647)
(div-test 32769 32767/2147483647 #'round -2147483648/2147483647 -65535/2147483647)
(div-test 2 0.5d0 #'round 3d0 1.25d0)
(div-test 3 -0.5d0 #'round 4d0 1.5d0)
(div-test -3 -0.5d0 #'round 4d0 -1.5d0)
(div-test -3 0.5d0 #'round -4d0 1.5d0)
(div-test 3 0.5d0 #'round -4d0 -1.5d0)
(div-test 1 2/91 #'round 5/7 9/13)
(div-test -1 2/91 #'round 5/7 -9/13)
(div-test -1 -2/91 #'round -5/7 9/13)
(div-test 1 -2/91 #'round -5/7 -9/13)
(div-test 1 0 #'round 2147483648/2147483647 2147483648/2147483647)
(div-test -1 0 #'round 2147483648/2147483647 -2147483648/2147483647)
(div-test -1 0 #'round -2147483648/2147483647 2147483648/2147483647)
(div-test 1 0 #'round -2147483648/2147483647 -2147483648/2147483647)
(div-test 9438 -313311293547183/144137437447079
	#'round 16324116304212832041/144137437447079 12)
(div-test -9438 -313311293547183/144137437447079
	#'round 16324116304212832041/144137437447079 -12)
(div-test -9438 313311293547183/144137437447079
	#'round -16324116304212832041/144137437447079 12)
(div-test 9438 313311293547183/144137437447079
	#'round -16324116304212832041/144137437447079 -12)
(div-test 8082 -1804074198964956721/720687187235395
	#'round 2147483648 1148972348912638496123/4324123123412370)
(div-test -8082 -1804074198964956721/720687187235395
	#'round 2147483648 -1148972348912638496123/4324123123412370)
(div-test -8082 1804074198964956721/720687187235395
	#'round -2147483648 1148972348912638496123/4324123123412370)
(div-test 8082 1804074198964956721/720687187235395
	#'round -2147483648 -1148972348912638496123/4324123123412370)
(div-test 0 1148972348912638496123/4324123123412370111
	#'round 1148972348912638496123/4324123123412370111 2147483648)
(div-test 0 1148972348912638496123/4324123123412370111
	#'round 1148972348912638496123/4324123123412370111 -2147483648)
(div-test 0 -1148972348912638496123/4324123123412370111
	#'round -1148972348912638496123/4324123123412370111 2147483648)
(div-test 0 -1148972348912638496123/4324123123412370111
	#'round -1148972348912638496123/4324123123412370111 -2147483648)
(div-test 0d0 1.0000000004656613d0 #'fround 2147483648/2147483647 2147483648d0)
(div-test 0d0 1.0000000004656613d0 #'fround 2147483648/2147483647 -2147483648d0)
(div-test 0d0 -1.0000000004656613d0 #'fround -2147483648/2147483647 2147483648d0)
(div-test 0d0 -1.0000000004656613d0 #'fround -2147483648/2147483647 -2147483648d0)
(div-test 2 0.5d0 #'round 2.5d0)
(div-test -2 -0.5d0 #'round -2.5d0)
(div-test 5 0d0 #'round 2.5d0 0.5d0)
(div-test -5 0d0 #'round 2.5d0 -0.5d0)
(div-test -5 0d0 #'round 2.5d0 -0.5d0)
(div-test -5 0d0 #'round -2.5d0 0.5d0)
(div-test 5 0d0 #'round -2.5d0 -0.5d0)
(div-test 1 -2/7 #'round 5/7)
(div-test -1 2/7 #'round -5/7)
(div-test 2 -1/2 #'round 3/2)
(div-test -2 1/2 #'round -3/2)
(div-test 2 1 #'round 30/2 7)
(div-test -2 1 #'round 30/2 -7)
(div-test -2 -1 #'round -30/2 7)
(div-test 2 -1 #'round -30/2 -7)
(div-test 1073741824 -1/2 #'round 2147483647/2)
(div-test -1073741824 1/2 #'round -2147483647/2)
(div-test 1 -2147483645/2 #'round 2147483647/2 2147483646)
(div-test -1 -2147483645/2 #'round 2147483647/2 -2147483646)
(div-test -1 2147483645/2 #'round -2147483647/2 2147483646)
(div-test 1 -2147483645/2 #'round 2147483647/2 2147483646)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; misc
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(test #c(5 -5) #'conjugate #c(5 5))
(test #c(5 5) #'conjugate #c(5 -5))
(test #c(-5 -5) #'conjugate #c(-5 5))
(test #c(-5 5) #'conjugate #c(-5 -5))

(test 1 #'denominator 10)
(test 3 #'denominator 10/3)
(test 3 #'denominator 1804074198964956721/3)
(test 4324123123412370111 #'denominator -1148972348912638496123/4324123123412370111)

(bool-test nil #'evenp -1)
(bool-test t #'evenp -2147483648)
(bool-test t #'evenp -4294967296)
(bool-test nil #'evenp -4294967295)

(test 0.5d0 #'float 1/2)
(test 10.0d0 #'float 10)
(test 4.978341823462786d22 #'float 49783418234627861238926)
(test 1.845867531346429d12 #'float 643827946123846123984/348794231)

(bool-test t #'floatp 0.3d0)
(bool-test nil #'floatp 1/3)

(test 0 #'imagpart 1)
(test -5 #'imagpart #c(1 -5))

(bool-test t #'integerp 12)
(bool-test nil #'integerp 1/2)
(bool-test nil #'integerp :test)
(bool-test nil #'integerp 0d0)
(bool-test t #'integerp 49783418234627861238926)

(test 3 #'isqrt 12)
(test 46340 #'isqrt 2147483648)
(test 46340 #'isqrt 2147483647)
(test 25373764918 #'isqrt 643827946123846123984)

(bool-test nil #'logtest 1 2)
(bool-test t #'logtest 1 3)
(bool-test t #'logtest 7 -1)

(bool-test nil #'minusp 0)
(bool-test nil #'minusp 2147483648)
(bool-test t #'minusp -2147483648)
(bool-test t #'minusp -1/4)
(bool-test nil #'minusp 0.2d0)
(bool-test nil #'minusp 0d0)
(bool-test nil #'minusp 984723891462817946123897416)
(bool-test t #'minusp -1148972348912638496123/4324123123412370111)

(bool-test t #'numberp #c(1 2))
(bool-test t #'numberp -200)
(bool-test nil #'numberp :test)

(test 10 #'numerator 10)
(test 10 #'numerator 10/3)
(test 1804074198964956721 #'numerator 1804074198964956721/3)
(test -1148972348912638496123 #'numerator -1148972348912638496123/4324123123412370111)

(bool-test t #'oddp -1)
(bool-test nil #'oddp -2147483648)
(bool-test nil #'oddp -4294967296)
(bool-test t #'oddp -4294967295)

(bool-test nil #'plusp 0)
(bool-test t #'plusp 2147483648)
(bool-test nil #'plusp -2147483648)
(bool-test nil #'plusp -1/4)
(bool-test t #'plusp 0.2d0)
(bool-test nil #'plusp 0d0)
(bool-test t #'plusp 984723891462817946123897416)
(bool-test nil #'plusp -1148972348912638496123/4324123123412370111)

(test 1/4 #'rational 0.25d0)
(test 5/2 #'rational 2.5d0)
(test 1/8 #'rational 0.125d0)
(test -5/8 #'rational -0.625d0)
(test 524293/8 #'rational 65536.625d0)
(test 17179869181/8 #'rational 2147483647.625d0)

(bool-test t #'rationalp -3)
(bool-test t #'rationalp 1/2)
(bool-test t #'rationalp 1/2412341242424122412)
(bool-test nil #'rationalp :test)
(bool-test nil #'rationalp 0d0)
(bool-test t #'rationalp 49783418234627861238926)

(test -1 #'realpart #c(-1 0.5d0))

(test 1 #'signum 123/5)
(test 0d0 #'signum 0d0)
(test -1d0 #'signum -7.3d0)

(bool-test nil #'zerop 1)
(bool-test nil #'zerop 1/4312412341234123412)
(bool-test nil #'zerop 0.000003d0)
(bool-test t #'zerop 0)
(bool-test t #'zerop 0d0)
(bool-test t #'zerop #c(0 0d0))

(bool-test t #'= 10 #c(10 0d0))

