/*	$NetBSD: run-crypto.c,v 1.4 2024/08/18 20:47:26 christos Exp $	*/

/* AUTOGENERATED FILE. DO NOT EDIT. */

//=======Test Runner Used To Run Each Test Below=====
#define RUN_TEST(TestFunc, TestLineNum) \
{ \
  Unity.CurrentTestName = #TestFunc; \
  Unity.CurrentTestLineNumber = TestLineNum; \
  Unity.NumberOfTests++; \
  if (TEST_PROTECT()) \
  { \
      setUp(); \
      TestFunc(); \
  } \
  if (TEST_PROTECT() && !TEST_IS_IGNORED) \
  { \
    tearDown(); \
  } \
  UnityConcludeTest(); \
}

//=======Automagically Detected Files To Include=====
#include "unity.h"
#include <setjmp.h>
#include <stdio.h>
#include "config.h"
#include "ntp_types.h"
#include "sntptest.h"
#include "crypto.h"

//=======External Functions This Runner Calls=====
extern void setUp(void);
extern void tearDown(void);
extern void test_MakeSHAKE128Mac(void);
extern void test_MakeSHA1Mac(void);
extern void test_MakeCMac(void);
extern void test_VerifySHAKE128(void);
extern void test_VerifySHA1(void);
extern void test_VerifyCMAC(void);
extern void test_VerifyFailure(void);
extern void test_PacketSizeNotMultipleOfFourBytes(void);


//=======Suite Setup=====
static void suite_setup(void)
{
extern int change_iobufs(int);
extern int change_logfile(const char*, int);
change_iobufs(1);
change_logfile("stderr", 0);
}

//=======Test Reset Option=====
void resetTest(void);
void resetTest(void)
{
  tearDown();
  setUp();
}

char const *progname;


//=======MAIN=====
int main(int argc, char *argv[])
{
  progname = argv[0];
  suite_setup();
  UnityBegin("crypto.c");
  RUN_TEST(test_MakeSHAKE128Mac, 14);
  RUN_TEST(test_MakeSHA1Mac, 15);
  RUN_TEST(test_MakeCMac, 16);
  RUN_TEST(test_VerifySHAKE128, 17);
  RUN_TEST(test_VerifySHA1, 18);
  RUN_TEST(test_VerifyCMAC, 19);
  RUN_TEST(test_VerifyFailure, 20);
  RUN_TEST(test_PacketSizeNotMultipleOfFourBytes, 21);

  return (UnityEnd());
}
