#!/bin/sh
# BuildAll: use this to build iTeXMac2 and its required frameworks from the command line
# XCode 2.2 compliant, version 1
pushd "`dirname "$0"`"
echo "Building the TeX Distribution Preference Pane"
if [ ${#} -gt 0 ]
then
    echo "xcodebuild -target All -configuration $1 clean build"
    xcodebuild -target "All" -configuration "$1" clean build
elif [ "${USER}" = "root" ]
then
    echo "xcodebuild -target \"All\" -configuration \"Deployment\" clean build"
    xcodebuild -target "All" -configuration "Deployment" clean build
else
    echo "xcodebuild -target \"All\" -configuration \"Development\" clean build"
    xcodebuild -target "All" -configuration "Development" clean build
fi
if [ $? -ne 0 ]
then
    popd
    exit 3
fi
