<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:output method="html" version="4.0" encoding="UTF-8" indent="yes"/>
    <!-- copy each html subnode nearly as is -->
    <xsl:template match="html//node()">
        <xsl:copy>
			<xsl:copy-of select="attribute::*"/>
			<xsl:apply-templates select="node()"/>
        </xsl:copy>
    </xsl:template>
    <xsl:template match="html//@*">
        <xsl:copy>
			<xsl:copy-of select="attribute::*"/>
			<xsl:apply-templates select="node()"/>
        </xsl:copy>
    </xsl:template>
    <!-- div inside a list is an item -->
    <xsl:template match="//div[@class='ordered-list' or @class='unordered-list']/div">
        <xsl:copy>
			<xsl:copy-of select="attribute::*"/>
			<xsl:attribute name="class">
				<xsl:text>item</xsl:text>
			</xsl:attribute>
			<xsl:apply-templates select="node()"/>
        </xsl:copy>
    </xsl:template>
    <xsl:template match="//code//code">
        <xsl:element name="a">
			<xsl:copy-of select="attribute::*"/>
			<xsl:apply-templates select="node()"/>
        </xsl:element>
    </xsl:template>
    <!--++++++++++++++++ Management of code nodes ++++++++++++++++-->
    <xsl:template match="code/insert">
        <!-- gobble -->
    </xsl:template>
    <xsl:template match="code/@inline">
        <!-- gobble -->
    </xsl:template>
    <xsl:template match="code/@display">
        <!-- gobble -->
    </xsl:template>
    <xsl:template match="//code[string-length()>0]">
		<!-- management of the anchor -->
		<xsl:element name="code">
			<xsl:copy-of select="attribute::*"/>
			<xsl:choose>
				<xsl:when test="string-length(@href)>0">
					<xsl:element name="a">
						<xsl:attribute name="href">
							<xsl:value-of select="@href"/>
						</xsl:attribute>
						<xsl:apply-templates/>
					</xsl:element>
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:element>
    </xsl:template>
    <xsl:template match="//code//code">
		<xsl:element name="SPAN">
			<xsl:copy-of select="attribute::*"/>
			<xsl:apply-templates/>
		</xsl:element>
    </xsl:template>
    <xsl:template match="//code//code[string-length(@href)>0]">
		<!-- management of the anchor -->
		<xsl:element name="SPAN">
			<xsl:copy-of select="attribute::*"/>
			<xsl:element name="a">
				<xsl:attribute name="href">
					<xsl:value-of select="@href"/>
				</xsl:attribute>
				<xsl:apply-templates/>
			</xsl:element>
		</xsl:element>
    </xsl:template>
	<!-- Manage the insert code, the current node is a code -->
    <xsl:template match="//insert">
        <xsl:choose>
			<!-- If there is a insert child -->
            <xsl:when test="string-length()>0">
                <xsl:element name="script">
					<!-- javascript will use this to display the proper icon with the proper  -->
                    <xsl:text>markInsert()</xsl:text>
				</xsl:element>
                <xsl:element name="SPAN">
                    <xsl:attribute name="class">
                        <xsl:text>insert</xsl:text>
                    </xsl:attribute>
					<xsl:value-of select="."/>
				</xsl:element>
            </xsl:when>
            <xsl:when test="(preceding::code[@class='insert'])[1]">
                <xsl:element name="script">
                    <xsl:text>markInsert()</xsl:text>
                </xsl:element>
                <xsl:element name="SPAN">
                    <xsl:attribute name="class">
                        <xsl:text>insert</xsl:text>
                    </xsl:attribute>
                    <xsl:value-of select="preceding::code[1]"/>
                </xsl:element>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    <!-- special preformatted: the "insert" icon is placed with the text -->
    <xsl:template match="code[@class='preformatted']">
		<xsl:element name="TABLE">
			<xsl:copy-of select="attribute::*"/>
			<xsl:element name="TR">
				<xsl:element name="TD">
					<xsl:element name="PRE">
						<xsl:copy>
							<xsl:copy-of select="attribute::*"/>
							<xsl:apply-templates select="node()[not(self::insert)]"/>
						</xsl:copy>
					</xsl:element>
				</xsl:element>
				<xsl:element name="TD">
                    <xsl:attribute name="valign">
						<xsl:element name="BR"/>
                        <xsl:text>top</xsl:text>
                    </xsl:attribute>
					<xsl:apply-templates select="insert"/>
				</xsl:element>
			</xsl:element>
		</xsl:element>
    </xsl:template>
    <!-- inline image from previous code -->
    <xsl:template name="inline-img">
		<xsl:param name="img"/>
		<xsl:if test="string-length($img)">
			<xsl:element name="img">
				<xsl:attribute name="class">
					<xsl:text>inline</xsl:text>
				</xsl:attribute>
				<xsl:attribute name="src">
					<xsl:text>../img/</xsl:text>
					<xsl:value-of select="$img"/>
					<xsl:text>.png</xsl:text>
				</xsl:attribute>
				<xsl:attribute name="alt">
					<xsl:value-of select="$img"/>
				</xsl:attribute>
			</xsl:element>
		</xsl:if>
    </xsl:template>
     <!-- display image from previous code -->
    <xsl:template name="display-img">
		<xsl:param name="img"/>
		<xsl:if test="string-length($img)">
			<xsl:element name="CENTER">
				<xsl:attribute name="class">
					<xsl:text>display</xsl:text>
				</xsl:attribute>
				<xsl:element name="img">
					<xsl:attribute name="src">
						<xsl:text>../img/</xsl:text>
						<xsl:value-of select="$img"/>
						<xsl:text>.png</xsl:text>
					</xsl:attribute>
					<xsl:attribute name="alt">
						<xsl:value-of select="$img"/>
					</xsl:attribute>
				</xsl:element>
			</xsl:element>
		</xsl:if>
    </xsl:template>
    <!-- special image -->
    <xsl:template match="img[@src='previous-code']">
		<!-- the image depends on the preceding code element-->
		<xsl:choose>
			<xsl:when test="string-length((preceding::code[@inline or @display])[last()]/@inline)">
				<xsl:call-template name="inline-img">
					<xsl:with-param name="img">
						<xsl:value-of select="(preceding::code[@inline or @display])[last()]/@inline"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="string-length(preceding::code[@inline or @display][1]/@display)">
				<xsl:call-template name="display-img">
					<xsl:with-param name="img">
						<xsl:value-of select="preceding::code[@inline or @display][1]/@display"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="preceding::code[@inline or @display][1]/@inline">
				<xsl:call-template name="inline-img">
					<xsl:with-param name="img">
						<xsl:value-of select="preceding::code[@inline or @display][1]"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="preceding::code[@inline or @display][1]/@display">
				<xsl:call-template name="display-img">
					<xsl:with-param name="img">
						<xsl:value-of select="preceding::code[@inline or @display][1]"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>MISSING PREVIOUS CODE</xsl:text>
				<xsl:for-each select="preceding::code[@inline or @display]">
					<xsl:text>VALUE:</xsl:text>
					<xsl:value-of select="."/>
					<xsl:text>INLINE:</xsl:text>
					<xsl:element name="br"/>
					<xsl:value-of select="@inline"/>
					<xsl:text>DISPLAY:</xsl:text>
					<xsl:value-of select="@display"/>
					<xsl:element name="br"/>
				</xsl:for-each>
				<xsl:text>TEST</xsl:text>
				<xsl:element name="br"/>
				<xsl:for-each select="preceding::code[(@inline or @display) and (position() = 2)]">
					<xsl:text>VALUE:</xsl:text>
					<xsl:value-of select="."/>
					<xsl:element name="br"/>
					<xsl:text>INLINE:</xsl:text>
					<xsl:value-of select="@inline"/>
					<xsl:element name="br"/>
					<xsl:text>DISPLAY:</xsl:text>
					<xsl:value-of select="@display"/>
					<xsl:element name="br"/>
				</xsl:for-each>
				<xsl:text>REPORT BUG</xsl:text>
				<xsl:element name="br"/>
				<xsl:variable name="nodes">
					<xsl:element name="wrapper">
						<xsl:copy-of select="preceding::code[@inline or @display]"/>
					</xsl:element>
				</xsl:variable>
				<xsl:value-of select="$nodes"/>
			</xsl:otherwise>
		</xsl:choose>
    </xsl:template>
    <!-- special image -->
    <xsl:template match="img[@src='next-code']">
		<!-- the image depends on the next code element-->
		<xsl:choose>
			<xsl:when test="string-length(following::code[@inline or @display][1]/@inline)">
					<xsl:call-template name="inline-img">
					<xsl:with-param name="img">
						<xsl:value-of select="following::code[@inline or @display][1]/@inline"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="string-length(following::code[@inline or @display][1]/@display)">
					<xsl:call-template name="display-img">
					<xsl:with-param name="img">
						<xsl:value-of select="following::code[@inline or @display][1]/@display"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="following::code[@inline or @display][1]/@inline">
					<xsl:call-template name="inline-img">
					<xsl:with-param name="img">
						<xsl:value-of select="following::code[@inline or @display][1]"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="following::code[@inline or @display][1]/@display">
					<xsl:call-template name="display-img">
					<xsl:with-param name="img">
						<xsl:value-of select="following::code[@inline or @display][1]"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
    </xsl:template>
    <!-- command head -->
    <xsl:template match="/html/head">
        <xsl:element name="head">
			<xsl:element name="title">
                <xsl:value-of select="/html/body/h1[@class='title']"/>
            </xsl:element>
			<xsl:element name="script">
                <xsl:attribute name="src">
					<xsl:text>latex.js</xsl:text>
				</xsl:attribute>
                <xsl:attribute name="type">
					<xsl:text>text/javascript</xsl:text>
				</xsl:attribute>
            </xsl:element>
			<xsl:element name="link">
                <xsl:attribute name="href">
                    <xsl:text>latex.css</xsl:text>
                </xsl:attribute>
                <xsl:attribute name="rel">
                    <xsl:text>stylesheet</xsl:text>
                </xsl:attribute>
                <xsl:attribute name="type">
                    <xsl:text>text/css</xsl:text>
                </xsl:attribute>
            </xsl:element>
        </xsl:element>
    </xsl:template>
    <!-- command body -->
    <xsl:template match="/html/body">
		<!-- Wraps the contents in a div element to be used by javascript -->
        <xsl:copy>
			<xsl:copy-of select="attribute::*"/>
			<!-- The content -->
			<xsl:element name="div">
				<xsl:attribute name="id">
					<xsl:text>content</xsl:text>
				</xsl:attribute>
				<xsl:apply-templates select="node()"/>
			</xsl:element>
			<!-- The footer -->
			<xsl:element name="div">
				<xsl:attribute name="id">
					<xsl:text>footer</xsl:text>
				</xsl:attribute>
				<xsl:variable name="footer">
					<xsl:apply-templates select="div[@style='footer']" mode="footer"/>
				</xsl:variable>
				<xsl:if test="string-length($footer)">
					<xsl:element name="hr"/>
					<xsl:copy-of select="$footer"/>
				</xsl:if>
				<xsl:element name="hr"/>
				<xsl:element name="p">
					<xsl:attribute name="class">
						<xsl:text>title</xsl:text>
					</xsl:attribute>
					<xsl:text>Back to the </xsl:text>
                    <xsl:element name="a">
                        <xsl:attribute name="href">
                            <xsl:text>ltx-2.html</xsl:text>
                        </xsl:attribute>
                        <xsl:text>Table of Contents</xsl:text>
					</xsl:element>
				</xsl:element>
			</xsl:element>
        </xsl:copy>
    </xsl:template>
    <!-- div with a footer style only in footer div -->
    <xsl:template match="//div[@style='footer']">
        <!-- gobble -->
    </xsl:template>
    <xsl:template match="//div[@style='footer']" mode="footer">
        <xsl:apply-templates/>
    </xsl:template>
    <!-- address gobbled -->
    <xsl:template match="//address">
        <!-- gobble -->
    </xsl:template>
    <!-- h2 -->
    <xsl:template match="//div[@class='ordered-list' or @class='unordered-list']/h2">
		<xsl:copy>
			<xsl:copy-of select="attribute::*"/>
			<xsl:attribute name="class">
				<xsl:text>list</xsl:text>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
    </xsl:template>
    <!-- main loop -->
    <xsl:template match="/">
        <xsl:element name="html">
            <xsl:attribute name="xmlns">
                <xsl:text>http://www.w3.org/1999/xhtml</xsl:text>
            </xsl:attribute>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>
</xsl:stylesheet>