//
//  main.m
//  TeXDistPreferenceApp
//
//  Created by coder on 04/12/06.
//  Copyright Laurens'Tribune 2006. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <WebKit/WebKit.h>

int main(int argc, char *argv[])
{
    return NSApplicationMain(argc,(const char **)argv);
}

#import "TeXDistributionBridge.h"
#import "TeXDistLockButton.h"

@interface myApplication:NSApplication
{
@private
	id tabView;
	id tableView;
	id TeXDistributionsController;
	id webView;
	id helpTextView;
	id descriptionView;
}
@end

@implementation myApplication
-(NSString *)paneHelpPath;// bound
{
	NSBundle * B = [NSBundle bundleForClass:[self class]];
	NSString * path = [B pathForResource:@"PrefPaneHelp" ofType:@"html"];
	return path;
}
-(BOOL)canEditPrefPaneHelp;
{
	return NO;
}
- (int)countOfTeXDistributions;
{
	return [[TeXDistributionBridge __TeXDistributions] count];
}
- (id)objectInTeXDistributionsAtIndex:(int)index;
{
	return [[TeXDistributionBridge __TeXDistributions] objectAtIndex:index];
}
- (NSArray *)sortDescriptors;
{
	return [NSArray arrayWithObjects:
				[[[NSSortDescriptor alloc] initWithKey:@"dirName" ascending:NO]autorelease],
				[[[NSSortDescriptor alloc] initWithKey:@"prettyName.lowercaseString" ascending:YES]autorelease],
					nil];
}
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  tableView:toolTipForCell:rect:tableColumn:row:mouseLocation::
- (NSString *)tableView:(NSTableView *)tv toolTipForCell:(NSCell *)cell rect:(NSRectPointer)rect tableColumn:(NSTableColumn *)tc row:(int)row mouseLocation:(NSPoint)mouseLocation;
/*"Thx http://www.corbinstreehouse.com/blog/?p=50.
Version History: jlaurens AT users DOT sourceforge DOT net
- 2.0
To Do List:
"*/
{
	NSArray * objects = [TeXDistributionsController arrangedObjects];
	id O = [objects objectAtIndex:row];
	if([[tc identifier] isEqual:@"prettyName"])
	{
		return [O valueForKey:@"fileName"];
	}
	else if([[tc identifier] isEqual:@"status"])
	{
		return [O valueForKey:@"statusDescription"];
	}
    return nil;
}
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  toggleLock:
- (IBAction)toggleLock:(id)sender;
{(@"Actual state:%@",([sender state]==NSOnState?@"On":@"Off"));
	[sender setLocked:(![sender locked])];(@"New    state:%@",([sender state]==NSOnState?@"On":@"Off"));
}
- (BOOL)canToggleLock;
{
	return NO;
}
- (BOOL)isDescriptionEditable;
{
	return NO;
}
@end

//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  NSView(TeXDist_Validate)
