//
//  TeXDistLockButton.m
//  TeXDist
//
//  Created by coder on 08/12/06.
//  Copyright 2006 __MyCompanyName__. All rights reserved.
//

#import "TeXDistLockButton.h"


@implementation TeXDistLockButton

- (id)initWithFrame:(NSRect)frameRect;
{
	if (self = [super initWithFrame:frameRect]) {
		[self TeXDist_setDefaultValues];
	}
	return self;
}

/* doesn't work in IB anyway ... :-(
- (id)initWithCoder:(NSCoder *)decoder
{
	self = [super initWithCoder:decoder];
	[[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(frameDidChangeNotified:) name:NSViewFrameDidChangeNotification object:self];
	[self setPostsFrameChangedNotifications:YES];
	return self;
}
*/

- (void)awakeFromNib
{
	[self TeXDist_setDefaultValues];
	NSString * name = @"Lock_Locked State";
	NSString * imageName = [@"TeXDist_" stringByAppendingString:name];
	NSImage * I = [NSImage imageNamed:imageName];
	if(!I)
	{
		NSBundle * B = [NSBundle bundleForClass:[self class]];
		NSArray * names = [NSArray arrayWithObjects:
			@"Lock_Locked State_Pressed",
			@"Lock_Locked State_Rollover",
			@"Lock_Locked State",
			@"Lock_Unlocked State_Pressed",
			@"Lock_Unlocked State_Rollover",
			@"Lock_Unlocked State",
			@"Lock_Open Anim 01",
			@"Lock_Open Anim 02",
			@"Lock_Open Anim 03",
			@"Lock_Open Anim 04",
			@"Lock_Open Anim 05",
			@"Lock_Open Anim 06",
			@"Lock_Open Anim 07",
			@"Lock_Open Anim 08",
			@"Lock_Open Anim 09",
			@"Lock_Open Anim 10",
			@"Lock_Open Anim 11",
			@"Lock_Open Anim 12",
			@"Lock_Open Anim 13",
			@"Lock_Open Anim 14",
			@"Lock_Open Anim 15",
			@"Lock_Roll",
				nil];
		NSEnumerator * E = [names objectEnumerator];
		while(name = [E nextObject])
		{
			NSString * path = [B pathForImageResource:name];
			if(path)
			{
				NSImage * I = [[NSImage alloc] initWithContentsOfFile:path];//not autoreleased, owned by the NSImage class
				imageName = [@"TeXDist_" stringByAppendingString:name];
				[I setName:imageName];
			}
		}
	}
	imageName = _Locked?
		@"TeXDist_Lock_Locked State":
		@"TeXDist_Lock_Unlocked State";
	if(I = [NSImage imageNamed:imageName])
	{
		[self setImage:I];
		[self setNeedsDisplay:YES];
	}
	else
	{
		NSLog(@"There is a problem of image named %@",imageName);
	}
	imageName = _Locked?
		@"TeXDist_Lock_Locked State_Pressed":
		@"TeXDist_Lock_Unlocked State_Pressed";
	if(I = [NSImage imageNamed:imageName])
	{
		[self setAlternateImage:I];
		[self setNeedsDisplay:YES];
	}
	else
	{
		NSLog(@"There is a problem of image named %@",imageName);
	}
}

- (void)TeXDist_setDefaultValues
{
	[animationTimer invalidate];
	[animationTimer release];
	animationTimer = nil;
	_Locked = YES;
	[[NSNotificationCenter defaultCenter] removeObserver:self name:NSViewFrameDidChangeNotification object:self];
	[[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(frameDidChangeNotified:) name:NSViewFrameDidChangeNotification object:self];
	[self setPostsFrameChangedNotifications:YES];
	//[self TeXDist_resetTrackingRect];
}

- (void)TeXDist_resetTrackingRect
{
	if (TeXDist_trackingRect) {
		[self removeTrackingRect:TeXDist_trackingRect];
	}
	NSRect trackingRect = [self frame];
	trackingRect.origin = NSZeroPoint;
	TeXDist_trackingRect = [self addTrackingRect:trackingRect owner:self userData:nil assumeInside:NO];
}

- (void)dealloc
{
	[self removeTrackingRect:TeXDist_trackingRect];
	[animationTimer invalidate];
	[animationTimer release];
	[super dealloc];
}

- (BOOL)locked;
{
	return _Locked;
}

- (void)setLocked:(BOOL)yorn;
{
	int actualState = _Locked;
	if(actualState != yorn)
	{
		_Locked = yorn;
		if(animationTimer)
		{
			return;
		}
		NSArray * names = [NSArray arrayWithObjects:
								@"TeXDist_Lock_Open Anim 01",
								@"TeXDist_Lock_Open Anim 02",
								@"TeXDist_Lock_Open Anim 03",
								@"TeXDist_Lock_Open Anim 04",
								@"TeXDist_Lock_Open Anim 05",
								@"TeXDist_Lock_Open Anim 06",
								@"TeXDist_Lock_Open Anim 07",
								@"TeXDist_Lock_Open Anim 08",
								@"TeXDist_Lock_Open Anim 09",
								@"TeXDist_Lock_Open Anim 10",
								@"TeXDist_Lock_Open Anim 11",
								@"TeXDist_Lock_Open Anim 12",
								@"TeXDist_Lock_Open Anim 13",
								@"TeXDist_Lock_Open Anim 14",
								@"TeXDist_Lock_Open Anim 15",
									nil];
		NSEnumerator * E = actualState == NSOnState?[names objectEnumerator]:[names reverseObjectEnumerator];
		animationTimer = [[NSTimer scheduledTimerWithTimeInterval:0.01 target:self selector:@selector(timedAnimate:) userInfo:E repeats:YES] retain];
	}
}

- (void)timedAnimate:(NSTimer *)theTimer;
{
	NSEnumerator * E = [theTimer userInfo];
	NSString * imageName = [E nextObject];
//NSLog(@"imageName:%@",imageName);
	NSImage * I = [NSImage imageNamed:imageName];
	if(I)
	{
		[self setImage:I];
		[self setNeedsDisplay:YES];
	}
	else
	{
		[animationTimer invalidate];
		[animationTimer autorelease];
		animationTimer = nil;
		NSWindow * W = [self window];
		NSPoint P = [W mouseLocationOutsideOfEventStream];
		P = [self convertPoint:P fromView:nil];
		NSString * imageName = nil;
		if(NSPointInRect(P,[self bounds]))
		{
			imageName = _Locked?
				@"TeXDist_Lock_Locked State_Rollover":
				@"TeXDist_Lock_Unlocked State_Rollover";
		}
		else
		{
			imageName = _Locked?
				@"TeXDist_Lock_Locked State":
				@"TeXDist_Lock_Unlocked State";
		}
		NSImage * I = nil;
		if(I = [NSImage imageNamed:imageName])
		{
			[self setImage:I];
			[self setNeedsDisplay:YES];
		}
		else
		{
			NSLog(@"There is a problem of image named %@",imageName);
		}
		imageName = _Locked?
			@"TeXDist_Lock_Locked State_Pressed":
			@"TeXDist_Lock_Unlocked State_Pressed";
		if(I = [NSImage imageNamed:imageName])
		{
			[self setAlternateImage:I];
			[self setNeedsDisplay:YES];
		}
		else
		{
			NSLog(@"There is a problem of image named %@",imageName);
		}
	}
}

- (void)mouseEntered:(NSEvent *)theEvent
{
	if(animationTimer)
	{
		return;
	}
	if ([self isEnabled])
	{
		NSString * imageName = _Locked?
			@"TeXDist_Lock_Locked State_Rollover":
			@"TeXDist_Lock_Unlocked State_Rollover";
		NSImage * I = [NSImage imageNamed:imageName];
		if(I)
		{
			[self setImage:I];
			[self setNeedsDisplay:YES];
		}
		else
		{
			NSLog(@"There is a problem of image named %@",imageName);
		}
	}
}

- (void)mouseExited:(NSEvent *)theEvent
{
	if(animationTimer)
	{
		return;
	}
	if ([self isEnabled])
	{
		NSString * imageName = _Locked?
			@"TeXDist_Lock_Locked State":
			@"TeXDist_Lock_Unlocked State";
		NSImage * I = [NSImage imageNamed:imageName];
		if(I)
		{
			[self setImage:I];
			[self setNeedsDisplay:YES];
		}
		else
		{
			NSLog(@"There is a problem of image named %@",imageName);
		}
	}
}

- (void)sizeToFit
{
	[super sizeToFit];
	[self TeXDist_resetTrackingRect];
}

- (void)frameDidChangeNotified:(NSNotification *)aNotification
{
	[self TeXDist_resetTrackingRect];
}

- (void)removeFromSuperview
{
	if (TeXDist_trackingRect) {
		[self removeTrackingRect:TeXDist_trackingRect];
	}
	[super removeFromSuperview];
}

- (void)removeFromSuperviewWithoutNeedingDisplay
{
	if (TeXDist_trackingRect) {
		[self removeTrackingRect:TeXDist_trackingRect];
	}
	[super removeFromSuperviewWithoutNeedingDisplay];
}

- (BOOL)acceptsFirstMouse:(NSEvent *)theEvent
{
	return YES;
}

- (void)viewDidMoveToWindow
{
	if ([self window]) {
		[self TeXDist_resetTrackingRect];
		[[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(frameDidChangeNotified:) name:NSWindowDidResizeNotification object:[self window]];
	} else {
		[self removeTrackingRect:TeXDist_trackingRect];
		[[NSNotificationCenter defaultCenter] removeObserver:self name:NSWindowDidResizeNotification object:nil];
	}
}

- (BOOL)canBecomeKeyView
{
	return NO;
}

@end
