//
//  TeXDistributionBridge.h
//  TeXDist
//
//  Created by coder on 08/12/06.
//  Copyright 2006 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@interface TeXDistributionBridge:NSObject
{
@private
	NSString * fileName;
	NSString * prettyName;
	NSString * dirName;
	NSString * contents;
	NSArray * powerpcProgramsDirs;// names like *powerpc* | *ppc* in foo.texdist/Contents
	NSArray * universalProgramsDirs;// names like *universal* in foo.texdist/Contents
	NSArray * intelProgramsDirs;// names like *intel* | *i386* in foo.texdist/Contents
	NSString * statusDescription;// text displayed with the caution icon
	NSString * currentPrograms;// target of foo.texdist/Contents/Programs
	NSAttributedString * attributedDescription;
	NSMutableDictionary * architectures;
	NSString * currentArchitecture;
	BOOL architectureMatches;// whether the current choice matches
	// private???
	BOOL debugDefault;// debug
	BOOL canChooseArchitecture;
	BOOL hasArchitectureProblem;
	BOOL lock;
}
+ (BOOL)isI386;
+ (BOOL)isAlternateKeyDown;
+ (BOOL)isKeyDown:(char)keyNumber;
+ (NSString *)TeXDistributionsPath;
+ (NSArray *)__TeXDistributions;
+ (id)defaultTeXDistribution;
+ (void)makeDefaultTeXDistribution:(TeXDistributionBridge *)distribution;
+ (void)destroyAuthorization;
- (id)initWithContentsFoFile:(NSString *)aFileName error:(NSError **)outErrorPtr;
- (NSString *)fileName;
- (NSString *)prettyName;
- (NSString *)dirName;
- (void)setDefault:(BOOL)yorn;
- (NSArray *)powerpcPrograms;
- (NSArray *)intelPrograms;
- (NSArray *)universalPrograms;
@end
