//
//  TeXDistPrefPanePref.m
//  TeXDistPrefPane
//
//  Created by coder on 08/12/06.
//  Copyright (c) 2006 Laurens'Tribune. All rights reserved.
//

#import "TeXDistPrefPanePref.h"
#import "TeXDistributionBridge.h"


@implementation TeXDistPrefPanePref

- (id)initWithBundle:(NSBundle *)bundle
{
    if (self = [super initWithBundle:bundle])
	{
		// register my embedded help book
		// it seems cocoa does not registers automagically
		if(bundle)
		{
			NSString * bundlePath = [bundle bundlePath];
			CFURLRef myBundleURL = (CFURLRef)[NSURL fileURLWithPath:bundlePath];// bridge
			if (myBundleURL)
			{
				FSRef myBundleRef;
				if (CFURLGetFSRef(myBundleURL, &myBundleRef))
				{
					OSStatus err = AHRegisterHelpBook(&myBundleRef);
					if(err)
					{
						NSLog(@"Could not register help book:%i",err);
					}
					else
					{
						NSLog(@"Help book registered, if any...");
					}
				}
			}
#if 0
This was an attempt to embed the TeXDistToo inside the pref pane bundle: failure
			NSString * sharedSupportPath = [bundle sharedSupportPath];
			NSString * TeXDistViewerPath = [sharedSupportPath stringByAppendingPathComponent:@"TeXDistTool.app"];
			if([[NSFileManager defaultManager] fileExistsAtPath:TeXDistViewerPath])
			{
				NSURL * url = [NSURL fileURLWithPath:TeXDistViewerPath];
				FSRef fsRef;
				if(CFURLGetFSRef((CFURLRef)url,&fsRef))
				{
					OSStatus err = LSRegisterFSRef(&fsRef,NO);
					if(err==kLSNoRegistrationInfoErr) NSLog(@"The item does not contain info requiring registration, report bug");
					else if(err==kLSDataErr) NSLog(@"The item's property list info is malformed, report bug");
					else NSLog(@"Registered TeXDist Viewer...");
#if MAC_OS_X_VERSION_10_4 <= MAC_OS_X_VERSION_MAX_ALLOWED
					err = LSSetDefaultRoleHandlerForContentType (
					   (CFStringRef) @"comp.text.tex.distribution.bridge",// this should be retrieved from the info.plist
					   kLSRolesAll,
					   (CFStringRef)TeXDistViewerPath);// it is too preemptive now
					if(err) NSLog(@"Error %i when LSSetDefaultRoleHandlerForContentType'ing, report bug",err);
#endif
				}
			}
#endif
		}
    }
    return self;
}

#if 0
- (void) mainViewDidLoad
{
}
#endif

- (BOOL)isDescriptionEditable;
{
	return NO;
}
- (int)countOfTeXDistributions;
{
	return [[TeXDistributionBridge __TeXDistributions] count];
}
- (id)objectInTeXDistributionsAtIndex:(int)index;
{
	return [[TeXDistributionBridge __TeXDistributions] objectAtIndex:index];
}
- (NSArray *)sortDescriptors;
{
	return [NSArray arrayWithObjects:
				[[[NSSortDescriptor alloc] initWithKey:@"dirName" ascending:NO]autorelease],
				[[[NSSortDescriptor alloc] initWithKey:@"prettyName.lowercaseString" ascending:YES]autorelease],
					nil];
}
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=  tableView:toolTipForCell:rect:tableColumn:row:mouseLocation::
- (NSString *)tableView:(NSTableView *)tv toolTipForCell:(NSCell *)cell rect:(NSRectPointer)rect tableColumn:(NSTableColumn *)tc row:(int)row mouseLocation:(NSPoint)mouseLocation;
/*"Thx http://www.corbinstreehouse.com/blog/?p=50.
Version History: jlaurens AT users DOT sourceforge DOT net
- 2.0
To Do List:
"*/
{
	NSArray * objects = [distributionsController arrangedObjects];
	id O = [objects objectAtIndex:row];
	if([[tc identifier] isEqual:@"prettyName"])
	{
		return [O valueForKey:@"fileName"];
	}
	if([[tc identifier] isEqual:@"status"])
	{
		return [O valueForKey:@"statusDescription"];
	}
    return nil;
}
- (void) didUnselect;
{
	[TeXDistributionBridge destroyAuthorization];
	return;
}
- (IBAction) showHelp:(id)sender;
{
	NSBundle * bundle = [NSBundle bundleForClass:[self class]];
	NSString * helpBookName = [bundle objectForInfoDictionaryKey:@"CFBundleHelpBookName"];

	if([helpBookName isKindOfClass:[NSString class]] && [helpBookName length])
	{
		AHLookupAnchor((CFStringRef)helpBookName,CFSTR("access"));// 4
	}
	else
	{
		NSLog(@"No help book name given...");
	}
	return;
}
@end
