//
//  main.m
//  TeXDistViewer
//
//  Created by coder on 03/12/06.
//  Copyright Laurens'Tribune 2006. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@interface TeXDistViewerAppDelegate: NSObject
@end

@interface TeXDistToolApp: NSApplication
@end

int main(int argc, char *argv[])
{
	NSAutoreleasePool * POOL = [[NSAutoreleasePool alloc] init];
	//NSLog(@"arguments:%@",[[NSProcessInfo processInfo] arguments]);
	[[TeXDistToolApp sharedApplication]
		setDelegate:[[TeXDistViewerAppDelegate alloc] init]];
    return NSApplicationMain(argc,  (const char **) argv);
	[POOL release];// unreachable code...
	return 0;
}

@implementation TeXDistToolApp: NSApplication
@end

@implementation TeXDistViewerAppDelegate
#if 1
- (void)application:(NSApplication *)sender openFiles:(NSArray *)filenames;
{
//NSLog(@"%s:%#x", __PRETTY_FUNCTION__,self);
	NSEnumerator * E = [filenames objectEnumerator];
	NSString * filename = nil;
	while(filename = [E nextObject])
	{
		NSString * dirname = [filename stringByAppendingPathComponent:@"Contents"];
		dirname = [dirname stringByAppendingPathComponent:@"Root"];
		if([[NSFileManager defaultManager] fileExistsAtPath:dirname])
		{
			[[NSWorkspace sharedWorkspace]
				selectFile:nil inFileViewerRootedAtPath:dirname];
		}
		else
		{
			NSString * coreName = [filename lastPathComponent];
			coreName = [coreName stringByDeletingPathExtension];
			NSString * source = [NSString stringWithFormat:
			@"tell application \"Finder\" to display alert \"%@\" message \"%@\" as warning",
			NSLocalizedString(@"Missing TeX Distribution",""),
			[NSString stringWithFormat:NSLocalizedString(@"Sorry, %@ not installed",""),coreName]];
			NSAppleScript * AS = [[[NSAppleScript alloc] initWithSource:source] autorelease];
			[AS executeAndReturnError:nil];
		}
	}
	[[NSApplication sharedApplication] terminate:self];
}
- (BOOL)applicationShouldOpenUntitledFile:(NSApplication *)sender;
{
	return YES;
}
- (void)applicationDidFinishLaunching:(NSNotification *)notification;
{
//NSLog(@"%s:%#x", __PRETTY_FUNCTION__,self);
	NSString * source = @"tell application \"System Preferences\"\nactivate\nset current pane to pane \"comp.text.tex.distribution.preference\"\nend tell";
	NSAppleScript * AS = [[[NSAppleScript alloc] initWithSource:source] autorelease];
	[AS executeAndReturnError:nil];
	[[NSApplication sharedApplication] terminate:self];
}
#endif
@end

@interface TeXDistDocument:NSDocument
@end

@implementation TeXDistDocument

- (NSString *)windowNibName
{
    // Implement this to return a nib to load OR implement -makeWindowControllers to manually create your controllers.
    return nil;//@"TeXDistDocument";
}

- (NSFileWrapper *)fileWrapperOfType:(NSString *)typeName error:(NSError **)outError;
{
    // Implement to provide a persistent data representation of your document OR remove this and implement the file-wrapper or file path based save methods.
    return nil;//unless you want to wipe out what is already there[[[NSFileWrapper alloc] initDirectoryWithFileWrappers:[NSDictionary dictionary]] autorelease];
}

- (BOOL)readFromFileWrapper:(NSFileWrapper *)fileWrapper ofType:(NSString *)typeName error:(NSError **)outError;
{
	return YES;
}

- (IBAction)close:(id)sender;
{
	[[NSApplication sharedApplication] terminate:self];
	return;
}

@end
