/* File:	Alert.m - (Interactive) Unix shell version of NXRunAlertPanel
 *
 * By:		Christopher Lane (lane@sumex-aim.stanford.edu)
 *
 * Date:	10 November 1992
 *
 * Modified:
 *	[12-Jul-95 TRH==Tom Hageman <Tom_Hageman@RnA.nl>], added -t, -i options.
 *	[17-Feb-96 TRH] Fix for Application option munching (like -NXHost);
 *		allow % signs in message.
 *	[12-Mar-96 TRH] add -V -H -A options; add EditMenu keyEquiv support.
 *
 * Copyright:	1990, 1991 & 1992 by The Leland Stanford Junior University.
 * This program may be distributed without restriction for non-commercial use.
 */

#define EXIT_USAGE (-1)	// overrides definition in ShellPanel.h

#define USES_APPICON
#define USES_KEYEQUIV
#import "ShellPanel.h"

#define USAGE "\
usage: %s [-A] [-t title] [-i icon] [-V] [-H] [message] [button1] [button2] [button3]\n"

#define HELP "\
options:\n\
 -t title     set title (default \"%s\")\n\
 -i iconfile  pathname of application icon to use (default none)\n\
 -A           do NOT activate, for less intrusive alerts (default activate)\n\
 -V           print version string and exit\n\
 -H           this help\n\
"

//	int NXRunAlertPanel(const char *title, const char *msg, const char *defaultButton,
//		const char *alternateButton, const char *otherButton, ...)

typedef enum {TITLE, MESSAGE, DEFAULT, ALTERNATE, OTHER, ARGC} ARGUMENTS;
typedef enum {ALERTDEFAULT = EXIT_SUCCESS, ALERTALTERNATE, ALERTOTHER, ALERTERROR} RESULTS;

void main(int argc, char *argv[])
{
	int result, context;
	const char *title, *iconFile;
	BOOL activate = YES;
	int option;

	NXApp = [Application new];
	argc = NXArgc, argv = NXArgv;	// Application may munch options.
	result = EXIT_SUCCESS;
	title = [NXApp appName];
	iconFile = NULL;

	while ((option = getopt(argc, argv, "t:i:AVH")) != EOF) {
		switch (option) {
		case 't': title = optarg;		break;
		case 'i': iconFile = optarg;		break;
		case 'A': activate = NO;		break;
		case 'V': result = EXIT_VERSION;	break;
		case 'H': result = EXIT_HELP;		break;
		default: result = EXIT_USAGE;
		}
	}
	HandleUsageHelpVersion(result, USAGE, HELP);

	SetAppIconToFile(iconFile);
	ProvideKeyEquivalents();

	context = [NXApp activateSelf:activate];

	argc -= optind - 1;
	argv += optind - 1;

	result = NXRunAlertPanel(
		(argc > TITLE) ? title : NULL,
		(argc > MESSAGE) ? "%s" : NULL,
		(argc > DEFAULT) ? argv[DEFAULT] : NULL,
		(argc > ALTERNATE) ? argv[ALTERNATE] : NULL,
		(argc > OTHER) ? argv[OTHER] : NULL,
		(argc > MESSAGE) ? argv[MESSAGE] : NULL
		);

	if (context) (void) [NXApp activate:context];
	[NXApp free];

	switch (result) {
	case NX_ALERTDEFAULT: exit(ALERTDEFAULT);
	case NX_ALERTALTERNATE: exit(ALERTALTERNATE);
	case NX_ALERTOTHER: exit(ALERTOTHER);
	}
	exit(ALERTERROR);
}
