/*+++*
 *  title:	InputlinePanel.h
 *  abstract:	An Inputline Panel in the style of NeXTSTEPs Alert Panel.
 *  author:	T.R.Hageman <Tom_Hageman@RnA.nl>
 *  created:	March 1996
 *  modified:	(see RCS Log at end)
 *  copyright:
 *
 *		Copyright (C) 1996 by Tom R. Hageman.
 *
 *	This software may be redistributed, used and modified without
 *	restriction, as long as this copyright notice is left intact,
 *	and modified versions of this software are clearly marked as such.
 *
 *	This software is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 *  description:
 *
 *	This class puts a friendly face on Inputline.
 *
 *	In order to do so at runtime, it also needs its accompanying
 *	InputlinePanel.nib to be installed in one of the following
 *	locations:
 *
 *	- the app's main bundle (for the Inputline tool, the directory
 *	  where its executable physically resides.)
 *	- ~/Library/Resources
 *	- /LocalLibrary/Resources
 *
 *---*/

#import <appkit/appkit.h>

@interface InputlinePanel : Panel
{
    id	iconButton;
    id	inputField;
    id	promptField;
    id	titleField;
}

// Class methods.
+ new;
  /* Create a shared instance of this class from the .nib file. */  

+ (const char *const *)resourcePaths;
  /* Support: where to look for the .nib. */

// Actions.  Used internally only.
- cancel:sender;
- ok:sender;

// Access methods.
- (void)setTitle:(const char *)aTitle;
- (const char *)title;
- (void)setPrompt:(const char *)aPrompt;
- (const char *)prompt;
- (void)setInputline:(const char *)anInputline;
- (const char *)inputline;

// Run the panel modally.
- (int)runModal;
  /* Shorthand for -runModalWithInputLine:"" invisible:NO. */

- (int)runModalWithInputline:(const char *)anInputline
	invisible:(BOOL)isInvisible;
  /* Runs the panel modally with `anInputline' as its initial value.
     If `isInvisible' is non-zero, the text color of the input field
     is set to its background color to render the input text invisible.
     This also resizes the panel as necessary to accommodate long title
     and prompt strings, before putting it on-screen at a prominent
     location (much like Alert panels).
     Returns NX_OKTAG or NX_CANCELTAG. */

@end // InputlinePanel

/*======================================================================
 * $Log: InputlinePanel.h,v $
 * Revision 1.3  1996/03/31 20:34:48  tom
 * fixed mail address.
 *
 * Revision 1.2  1996/03/28 23:15:33  tom
 * Commented.
 *
 *======================================================================*/
