/* File: NIDomain.m - (Interactive) Unix shell version of NIDomainPanel
 *
 * By: Christopher Lane (lane@sumex-aim.stanford.edu)
 *
 * Date: 16 July 1991
 *
 * Modified:
 *	[17-Feb-96 TRH] Fix for Application option munching (like -NXHost).
 *	[15-Mar-96 TRH] add -V -H -i options; add EditMenu keyEquiv support.
 *
 * Copyright: 1991 by The Leland Stanford Junior University.
 */

#define USES_APPICON
#define USES_KEYEQUIV
#import "ShellPanel.h"

#import <nikit/NIDomainPanel.h>

#define USAGE "\
usage: %s [-i icon] [-V] [-H]\n"

#define HELP "\
options:\n\
 -i iconfile  pathname of application icon to use (default none)\n\
 -V           print version string and exit\n\
 -H           this help\n\
"


void main(int argc, char *argv[])
{
	const char *iconFile = NULL;
	int option, status = EXIT_SUCCESS;

	NXApp = [Application new];
	argc = NXArgc, argv = NXArgv;	// Application may munch options.

	while ((option = getopt(argc, argv, "i:VH")) != EOF)
		switch (option) {
		case 'i': iconFile = optarg; break;
		case 'V': status = EXIT_VERSION; break;
		case 'H': status = EXIT_HELP; break;
		default : status = EXIT_USAGE;
		}
	if (optind < argc) status = EXIT_USAGE;

	HandleUsageHelpVersion(status, USAGE, HELP);

	SetAppIconToFile(iconFile);
	ProvideKeyEquivalents();
	{
		int flags, context = [NXApp activateSelf:YES];
		NIDomainPanel *panel = [NIDomainPanel new];

		if ((flags = [panel runModal]) == NX_OKTAG) (void) puts([panel domain]);
		else status = flags;

		[panel free];

		if (context) (void) [NXApp activate:context];
	}

	[NXApp free];

	exit(status);
}
