/* File: Save.m - (Interactive) Unix shell version of SavePanel
 *
 * By: Christopher Lane (lane@sumex-aim.stanford.edu)
 *
 * Date: 10 November 1992
 *
 * Modified:
 *	[17-Feb-96 TRH] Fix for Application option munching (like -NXHost).
 *	[12-Mar-96 TRH] add -V -H -A options; add EditMenu keyEquiv support.
 *
 * Copyright: 1990, 1991 & 1992 by The Leland Stanford Junior University.
 */

#define USES_APPICON
#define USES_KEYEQUIV
#import "ShellPanel.h"

#define USAGE "\
usage: %s [-f file] [-d directory] [-e type] [-p prompt] [-t title] [-i icon] [-u] [-V] [-H]\n"

#define HELP "\
options:\n\
 -f file      initial filename to display in the name field\n\
 -d directory initial directory to display in the browser\n\
 -e type      type (extension) of files to accept; multiple allowed\n\
 -p prompt    set prompt (default \"Name:\")\n\
 -t title     set title (default \"%s\")\n\
 -i iconfile  pathname of application icon to use (default none)\n\
 -u           travel inside file packages (e.g. app wrappers)\n\
 -V           print version string and exit\n\
 -H           this help\n\
"


void main(int argc, char *argv[])
{
	const char *prompt = NULL;
	const char *title = NULL;
	const char *iconFile = NULL;
	const char *type = NULL;
	BOOL transparent = NO;
	const char *name = NULL, *path = NULL;
	int option, status = EXIT_SUCCESS;

	NXApp = [Application new];
	argc = NXArgc, argv = NXArgv;	// Application may munch options.

	while ((option = getopt(argc, argv, "f:d:e:p:t:i:uVH")) != EOF)
		switch (option) {
		case 'f': name = optarg; break;
		case 'd': path = optarg; break;
		case 'e': type = optarg; break;
		case 'p': prompt = optarg; break;
		case 't': title = optarg; break;
		case 'i': iconFile = optarg; break;
		case 'u': transparent = YES; break;
		case 'V': status = EXIT_VERSION; break;
		case 'H': status = EXIT_HELP; break;
		default : status = EXIT_USAGE;
		}
	if (optind < argc) status = EXIT_USAGE;

	HandleUsageHelpVersion(status, USAGE, HELP);

	SetAppIconToFile(iconFile);
	ProvideKeyEquivalents();

	{
		SavePanel *panel = [SavePanel new];
		int context = [NXApp activateSelf:YES];

		if (type) [panel setRequiredFileType:type];
		if (prompt) [panel setPrompt:prompt];
		if (title) [panel setTitle:title];

		[panel setTreatsFilePackagesAsDirectories:transparent];

		if ([panel runModalForDirectory:path file:name]) (void) puts([panel filename]);
		else status = EXIT_FAILURE;

		if (context) (void) [NXApp activate:context];

		[panel free];
	}

	[NXApp free];

	exit(status);
}
