#if !defined(_POSIX_SOURCE)
/* getcwd for olden BSD systems. */

#include <string.h>
#include <stdlib.h>
#include <errno.h>

extern char *getwd();

char *
getcwd(buf, size)
  char *buf;
  size_t size;
{
	char wd[1024+1];	/* XXX should be MAXPATHLEN */
	size_t len;

	if (size == 0) {
		errno = EINVAL;
		return NULL;
	}
	getwd(wd);
	if ((len = strlen(wd)) >= size) {
		errno = ERANGE;
		return NULL;
	}
	if (buf == NULL && (buf = malloc(len + 1)) == NULL) {
		errno = EAGAIN;
		return NULL;
	}
	return strcpy(buf, wd);
}
#endif /* _POSIX_SOURCE */
