/* Quick&Dirty putenv() */

#include <string.h>
#include <stdlib.h>
#include <errno.h>

int
putenv(envstr)
char *envstr;
{
	extern char **environ;
	static char **envbase = {0};
	char **envp, **newenv;
	char *s, *e;
	int var_len;

	if (!(s = envstr)) {
		errno = EINVAL;
		return -1;
	}
	/* scan for '=' in envstr.  If not found, i.e., VAR, delete variable. */
	while (*s) {
		if (*s++ == '=') {
			--s;
			break;
		}
	}
	var_len = (s - envstr);

	envp = environ;
	do {
		if (!(e = *envp++)) {
			/* Not found. */
			if (*s == '\0') {
				/* Try to delete a non-existing variable. */
				return 0;
			}
			/* Expand environ vector. */
			newenv = malloc((envp - environ + 1) * sizeof(*envp));
			if (!newenv) {
				return -1;
			}
			memcpy(newenv, environ, (envp - environ) * sizeof(*envp));
			if (envbase) {
				free(envbase);
			}
			envbase = newenv;

			/* relocate pointers. */
			envp = newenv + (envp - environ);
			environ = newenv;
			*envp = 0;
			break;
		}
	} while (!(strncmp(e, envstr, var_len) == 0 && e[var_len] == '='));

	if (*s == '\0') {	/* Delete this variable. */
		do  envp[-1] = envp[0];  while (*envp++);
	}
	else {			/* replace/add variable. */
		*--envp = envstr;
	}
	return 0;
}
