#if !defined(_POSIX_SOURCE)
/*
 * Dissociate the calling process from its controlling terminal,
 * and make it the process group leader.
 */
#include <sys/types.h>
#include <errno.h>
#include <fcntl.h>
#include <sgtty.h>

int
setsid()
{
    int fd, pid = getpid(), result = pid;

    if (getpgrp(0) == pid) {	/* Calling process is process group leader. */
	errno = EPERM;
	return -1;
    }

    /* Dissociate the calling process from its controlling terminal. */
    if ((fd = open("/dev/tty", O_RDWR)) >= 0) {
	if (ioctl(fd, TIOCNOTTY, 0) < 0)
	    result = -1;
	close(fd);
    }
    /* else the process did not have a controlling terminal,
       so there is nothing to dissociate from. */

    /* make myself the process group leader. */
    if (setpgrp(pid, pid) < 0)
	result = -1;

    return result;
}
#endif
