#if !defined(_POSIX_SOURCE)
/*
 * Emulate Posix.1 waitpid() with BSD wait4.
 *
 * Bugs: Process group waits (i.e. pid == 0 or pid < -1) are not supported.
 */
#include <sys/types.h>
#include <errno.h>
#include <sys/wait.h>

int
waitpid(pid, stat_loc, options)
  int	pid;
  int	*stat_loc;
  int	options;
{
    if (pid <= 0)
    {
	if (pid != -1)
	{
		    errno = EINVAL;
		    return -1;
	}
	pid = 0;	/* wait4() expects pid=0 for indiscriminate wait. */
    }
    return wait4( pid, (union wait *)stat_loc, options, NULL);
}
#endif
