/*
 *
 *  $Header: /usr/home/hellmann/nedit_add_ons/RCS/mgrep.c,v 1.14 96/06/03 11:36:54 hellmann Exp $
 *
 *  FILENAME: grep.c
 *
 *  PURPOSE: Present the user with a window in which they can enter
 *           a text pattern and a file list pattern.  These will be
 *           used as input to grep, and the results will be displayed.
 *
 *  AUTHOR: Doug Hellmann
 *
 *  DATE: Fri Aug 18 15:39:45 EDT 1995
 *
 *  COMMENTS: 
 *
 *    RCSLOG:   $Log:	mgrep.c,v $
** Revision 1.14  96/06/03  11:36:54  hellmann
** Added standard preferences dialog.
** 
** Revision 1.13  96/03/01  15:10:13  hellmann
** Attempt to make colors and other resources more consistent.
** 
** Revision 1.12  96/02/29  12:22:57  hellmann
** Started using CmdOptions system for defining command arguments.
** 
** Revision 1.11  96/02/21  17:39:38  hellmann
** Added/updated header.
** 
 *
*/

#include "client.h"
#include "commandOptions.h"


	/* D E F I N I T I O N S */

#ifdef LOCAL_PREF_FILE_NAME
#undef LOCAL_PREF_FILE_NAME
#endif
#define LOCAL_PREF_FILE_NAME ".mgrep"

#ifdef APP_NAME
#undef APP_NAME
#endif
#define APP_NAME "mgrep" /* application name for loading resources */

#ifdef APP_CLASS
#undef APP_CLASS
#endif
#define APP_CLASS "MGrep"

#define MAXLINE 512
#define MAX_TAG_LEN 80

	/* T Y P E D E F S */

	/* G L O B A L S */

XtAppContext context;
Widget grepDialog = NULL;
Widget grepMatchPattern = NULL;
extern CmdOption mgrepOptions[];

char HeaderText[] = "\
# Preferences file for MGrep\n\
#\n\
# This file is created automatically by MGrep.\n\
#\n\
# Codes to be embedded in editor option: \n\
#\n\
#    %f - filename\n\
#    %t - tag name\n\
#    %l - line number\n\
#\n";

char *fallbackResources[] = {
    "*menuBar.marginHeight: 1",
    "*pane.sashHeight: 11",
    "*pane.sashWidth: 11",
    "*text.selectionArrayCount: 3",
    "*fontList:-adobe-helvetica-bold-r-normal-*-14-*-*-*-*-*-*-*",
    "*XmList.fontList:-adobe-courier-medium-r-normal-*-12-*-*-*-*-*-*-*",
    "*XmText.fontList:-adobe-courier-medium-r-normal-*-12-*-*-*-*-*-*-*",
    "*XmTextField.fontList:-adobe-courier-medium-r-normal-*-12-*-*-*-*-*-*-*",
    
    "*XmText.background: white",
    "*XmText.foreground: black",
    
    "*XmList.background: grey",
    "*XmList.foreground: black",
    
    "*XmLabel.foreground: black",
    "*XmPushButton.foreground: black",
    "*XmCascadeButton.foreground: black",
    "*XmToggleButton.foreground: black",
    
    "*background: grey",
    "*foreground: black",

    "*statisticsLine.background: #b3b3b3",
    "*text.background: #e5e5e5",
    "*text.foreground: black",
    "*XmText*foreground: black",
    "*XmText*background: white",
    "*XmList*foreground: black",
    "*XmList*background: white",
    "*XmTextField*background: #cccccc",
    "*XmTextField*foreground: black",
    "*AldoraHelp*background: lemon chiffon",
    "*AldoraHelp*foreground: black",
    "*grep_list.scrollBarDisplayPolicy: STATIC",
    "*grep_list.listSizePolicy: CONSTANT",
    
    "*main_menu*Grep.mnemonic: G",
    
    "*main_menu*Options.mnemonic: O",
    
    "*main_menu*Search.mnemonic: S",
    "*main_menu*Search.acceleratorText: Ctrl+S",
    "*main_menu*Search.accelerator: Ctrl<Key>S",
    
    "*main_menu*Exit.mnemonic: E",
    "*main_menu*Exit.acceleratorText: Alt+F4",
    "*main_menu*Exit.accelerator: Altr<Key>F4",
    
    "*pattern_menu*button_0.labelString: Lines matching",
    
    "*pattern_menu*button_1.labelString: Lines not matching",
    
    NULL
};

char cmdLineHelp[] =
#ifndef VMS
"Usage:  mgrep [-editor editor_name]\n\
		[-font font] [-display [host]:server[.screen]\n\
               [-geometry geometry] [-xrm resourcestring] [file...]\n";
#else
"";
#endif /*VMS*/

XrmOptionDescRec LocalOpTable[] = {
    {"-editor", ".editor", XrmoptionSepArg, (caddr_t)NULL},
};

struct localPrefData {
    char editor[MAXPATHLEN];		/* name of editor command under X */
    char grepFiles[MAXPATHLEN];				/* which files to include in the grep dialog */
} LocalPrefData;

PrefDescripRec LocalPrefDescrip[] = {
    {"editor", "Editor", PREF_STRING,
    	"xterm -title %f -exec vi +%l %f &",
    	LocalPrefData.editor, (void *)sizeof(LocalPrefData.editor), True},
    {"grepFiles", "GrepFiles", PREF_STRING,
    	"*.[ch]",
    	LocalPrefData.grepFiles, (void *)sizeof(LocalPrefData.grepFiles), True},
};

static Widget grepList, 	/* list for grep output */
              grepTextSearch, 	/* for user to tell us what to look for */
              grepTextFiles,    /* for user to tell us which files to search */
              grepOk, 		/* ok button (executes search) */
              grepCancel;	/* cancel button (dismisses dialog) */

	/* P R E D E C L A R A T I O N S   A N D   P R O T O T Y P E S */ 

extern char * GetPrefGrepFiles(void);
Widget CreateGrepDialog();
extern WindowInfo * FindWindowWithFile(char*, char*);


	/* C O D E */	  

/*
** Functions to return preferences values.
*/

char * GetPrefEditorCommand(void)
{
  return LocalPrefData.editor;
}

char * GetPrefGrepFiles(void)
{
    return LocalPrefData.grepFiles;
}


/*
 *
 * PURPOSE: Show the grep dialog.
 *
 * CALLED AS RESULT OF: Menu choice.
 *
*/
void ShowGrepWindow(Widget w, XtPointer xtp1, XtPointer xtp2)
{
  if (!grepDialog)
    grepDialog = CreateGrepDialog();
  XtPopdown(grepDialog);
  XtPopup(grepDialog, XtGrabNone);
}


/*
 *
 * PURPOSE: Perform search.
 *
 * CALLED AS RESULT OF: Activate callback on text widget or Ok button.
 *
*/
void grepSearchCB(Widget w, XtPointer xtp1, XtPointer xtp2)
{
  char * pattern;
  char * files;
  FILE * search;
  char cmd[1024];
  char buf[128];
  char * options;
  int success;
  int i;
  
  pattern = XmTextGetString(grepTextSearch);
  if (!pattern)
    return;
  if (!*pattern)
    return;
    
  files = XmTextGetString(grepTextFiles);
  if (!files)
  {
    XtFree(pattern);
    return;
  }
  if (!*files)
  {
    XtFree(pattern);
    return;
  }
  
  XmListDeleteAllItems(grepList);
  
  /*
   * Always pass /dev/null as a parameter so that grep has more than one
   * file name on the command line, and it will always print the file name.
   * It sure would be nice if there were a command line argument to do that.
  */
  
/* 
  sprintf(cmd, "grep -ns '%s' %s /dev/null", pattern, files);
 */
  sprintf(cmd, "grep -ns");
  
  options = BuildOptionString(mgrepOptions);
  strcat(cmd, options);
  free(options);
  
  if (OptionMenuGetValue(grepMatchPattern) == 1)
  	strcat(cmd, " -v ");
  
  strcat(cmd, " '");
  strcat(cmd, pattern);
  strcat(cmd, "' ");
  strcat(cmd, files);
  strcat(cmd, " /dev/null ");
  
#ifdef DEBUG_Mgrep
  fprintf(stderr, "command is :%s:\n", cmd);
#endif
  
  issueCommandToList(grepDialog, cmd, "", 0, grepList, &success);
  
  XtFree(pattern);
  XtFree(files);
}

/*
 *
 * PURPOSE: When the user selects an item, we take them to the source file
 *          at that point.
 *
 * CALLED AS RESULT OF: User selection in list (single select or default 
 *                      action).
 *
*/
void grepGotoCB(Widget w, XtPointer xtp1, XtPointer xtp2)
{
  char * full_line;
  char * line_num;
  char * file_name;
  char * buf;
  XmListCallbackStruct * cbs = (XmListCallbackStruct*)xtp2;
  int line_num_i;
  char filename[MAXPATHLEN], pathname[MAXPATHLEN];
  WindowInfo * window;
 
  XmStringGetLtoR(cbs->item, XmSTRING_DEFAULT_CHARSET, &buf);
  
  full_line = buf;
  
  file_name = full_line;
  
  for (full_line++; *full_line != ':'; full_line++);
  *full_line = '\0';
  full_line++;
  
  line_num = full_line;
  for (full_line++; *full_line != ':'; full_line++);
  *full_line = '\0';
  
  ParseFilename(file_name, filename, pathname);
  
  line_num_i = atol(line_num);
   
  RemoteEditFile(pathname, filename, line_num_i);
   
  XtFree(buf);
}


/*
 *
 * PURPOSE: Creates the window for the grep interface.
 *
 * PARAMETERS: None.
 *
 * RETURNS: Dialog (child) created.
 *
*/

Widget CreateGrepDialog()
{
  Widget Return;
  Pixmap iconPixmap = 0, maskPixmap = 0;
  Widget form, sep;
  Widget tags_list_window;
  Widget label;
  Widget frame1, frame2, frame3;
  Widget main_menu, menu, button;
  int i;
  
  Return = NeditCreateToplevelDialog("nedit_grep_list", "MGrep", "Grep");
  
      /* the form is the root widget */

  form = XtVaCreateWidget("grep_list_form", xmFormWidgetClass, 
    			      Return,
    			      XmNtopOffset, 2,
    			      XmNbottomOffset, 2,
    			      XmNleftOffset, 2,
    			      XmNrightOffset, 2,
    			      NULL);

	/* menu bar */
    			      
  main_menu = XmCreateMenuBar(form, "main_menu", NULL, 0);
  XtVaSetValues(main_menu, XmNleftAttachment, XmATTACH_FORM,
  			   XmNrightAttachment, XmATTACH_FORM,
  			   XmNtopAttachment, XmATTACH_FORM,
  			   NULL);
  XtManageChild(main_menu);
  
  	/* make */
  	
  button = XtVaCreateManagedWidget("Grep", xmCascadeButtonWidgetClass,
  				main_menu,
  				NULL);
  menu = XmCreatePulldownMenu(main_menu, "grep_menu", NULL, 0);
  XtVaSetValues(button, XmNsubMenuId, menu, NULL);

  button = XtVaCreateManagedWidget("Search", xmPushButtonWidgetClass,
  				menu,
  				NULL);
  XtAddCallback(button, XmNactivateCallback, 
  		(XtCallbackProc) grepSearchCB, NULL);

  button = XtVaCreateManagedWidget("Exit", xmPushButtonWidgetClass,
  				menu,
  				NULL);
  XtAddCallback(button, XmNactivateCallback, 
		      (XtCallbackProc) ClientExitCB, (XtPointer) grepDialog);

		/* options */

  button = XtVaCreateManagedWidget("Options", xmCascadeButtonWidgetClass,
  				main_menu,
  				NULL);
  menu = XmCreatePulldownMenu(main_menu, "grep_menu", NULL, 0);
  XtVaSetValues(button, XmNsubMenuId, menu, NULL);
  
  BuildOptionMenu(menu, mgrepOptions);
  
  /*
  ** Application specific user defined options.
  */
  PrefDialogAttachToMenu("Preferences...", menu, 
  	LocalPrefDescrip, XtNumber(LocalPrefDescrip));
  
      /* create the action area buttons */

  grepCancel = XtVaCreateManagedWidget("Exit", xmPushButtonWidgetClass,
    			      form,
    			      XmNrightAttachment, XmATTACH_FORM,
    			      XmNbottomAttachment, XmATTACH_FORM,
    			      XmNbottomOffset, 4,
    			      XmNrightOffset, 4,
    			      NULL);
  XtAddCallback(grepCancel, XmNactivateCallback, 
		      (XtCallbackProc) ClientExitCB, (XtPointer) grepDialog);

  grepOk = XtVaCreateManagedWidget("Search", xmPushButtonWidgetClass,
    			      form,
    			      XmNleftAttachment, XmATTACH_FORM,
    			      XmNbottomAttachment, XmATTACH_FORM,
    			      XmNbottomOffset, 4,
    			      XmNleftOffset, 4,
    			      XmNshowAsDefault, True,
    			      NULL);
  XtAddCallback(grepOk, XmNactivateCallback, 
		      (XtCallbackProc) grepSearchCB, NULL);

  sep = XtVaCreateManagedWidget("sep", xmSeparatorWidgetClass, form,
    			      XmNleftAttachment, XmATTACH_FORM,
    			      XmNrightAttachment, XmATTACH_FORM,
    			      XmNbottomAttachment, XmATTACH_WIDGET,
    			      XmNbottomWidget, grepOk,
    			      NULL);
    			      
  grepMatchPattern = XmVaCreateSimpleOptionMenu(form, "pattern_menu", NULL,
  		NULL, 0,
  		(XtCallbackProc) NULL,
  		XmVaPUSHBUTTON, NULL, NULL, NULL, NULL, /* displays matches */
  		XmVaPUSHBUTTON, NULL, NULL, NULL, NULL, /* displays non-matches */
  		
  			      XmNleftAttachment, XmATTACH_FORM,
  			      XmNbottomAttachment, XmATTACH_WIDGET,
  			      XmNbottomWidget, sep,

  		NULL);
  	XtManageChild(grepMatchPattern);
/* 
  	AldoraHelp_Add(callTreeDirection, "Display all calls made from root or\nall calls made to root function.");
 */
  
  label = grepMatchPattern;

  grepTextSearch = XtVaCreateManagedWidget("search_pattern_text", xmTextWidgetClass, form,
  			      XmNleftAttachment, XmATTACH_WIDGET,
  			      XmNleftWidget, label,
  			      XmNrightAttachment, XmATTACH_FORM,
  			      XmNbottomAttachment, XmATTACH_WIDGET,
  			      XmNbottomWidget, sep,
  			      NULL);  			      
  XtAddCallback(grepTextSearch, XmNactivateCallback, 
		      (XtCallbackProc) grepSearchCB, NULL);

  grepTextFiles = XtVaCreateManagedWidget("search_files_text", xmTextWidgetClass, form,
  			      XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET,
  			      XmNleftWidget, grepTextSearch,
  			      XmNrightAttachment, XmATTACH_FORM,
  			      XmNbottomAttachment, XmATTACH_WIDGET,
  			      XmNbottomWidget, grepTextSearch,
  			      NULL);
  XmTextSetString(grepTextFiles, GetPrefGrepFiles());
  XtAddCallback(grepTextFiles, XmNactivateCallback, 
		      (XtCallbackProc) grepSearchCB, NULL);
  label = XtVaCreateManagedWidget("Files: ", xmLabelWidgetClass, form,
  			      XmNleftAttachment, XmATTACH_FORM,
  			      XmNrightAttachment, XmATTACH_WIDGET,
  			      XmNrightWidget, grepTextFiles,
  			      XmNbottomAttachment, XmATTACH_WIDGET,
  			      XmNbottomWidget, grepTextSearch,
  			      XmNbottomOffset, 4,
  			      XmNalignment, XmALIGNMENT_END,
  			      NULL);
  			      
  sep = XtVaCreateManagedWidget("sep", xmSeparatorWidgetClass, form,
    			      XmNleftAttachment, XmATTACH_FORM,
    			      XmNrightAttachment, XmATTACH_FORM,
    			      XmNbottomAttachment, XmATTACH_WIDGET,
    			      XmNbottomWidget, grepTextFiles,
    			      NULL);

  grepList = XmCreateScrolledList(form, "grep_list", NULL, 0);
  XtVaSetValues(XtParent(grepList),
  		XmNleftAttachment, XmATTACH_FORM,
  		XmNrightAttachment, XmATTACH_FORM,
  		XmNtopAttachment, XmATTACH_WIDGET,
  		XmNtopWidget, main_menu,
  		XmNbottomAttachment, XmATTACH_WIDGET,
  		XmNbottomWidget, sep,
  		XmNwidth, 700,
  		NULL);
  XtVaSetValues(grepList, 
  		XmNvisibleItemCount, 20, 
  		XmNwidth, 500,
  		XmNselectionPolicy, XmSINGLE_SELECT,
  		XmNscrollingPolicy, XmAUTOMATIC,
  		XmNscrollBarDisplayPolicy, XmSTATIC,
  		NULL);
  XtAddCallback(grepList, XmNsingleSelectionCallback, grepGotoCB, NULL);
  XtAddCallback(grepList, XmNdefaultActionCallback, grepGotoCB, NULL);

  XtManageChild(grepList);
  XtManageChild(form);
  
  return Return;
}


/*
** Main function
*/

int main(int argc, char **argv)
{
    int i, fileSpecified;
    XrmDatabase prefDB, localPrefDB;
    Widget dialog;
    
    /* Initialize toolkit and open display. */

    XtToolkitInitialize();
    context = XtCreateApplicationContext();
    if (!context)
    {
	XtWarning ("MCflow: Can't get context\n");
	exit(0);
    }

    /* Set up a warning handler to trap obnoxious Xt grab warnings */
    SuppressPassiveGrabWarnings();

    /* Set up default resources if no app-defaults file is found */
    XtAppSetFallbackResources(context, fallbackResources);
    
#if XmVersion >= 1002
    /* Allow users to change tear off menus with X resources */
    XmRepTypeInstallTearOffModelConverter();
#endif /* XmVersion */
    
#ifdef VMS
    /* Convert the command line to Unix style (This is not an ideal solution) */
    ConvertVMSCommandLine(&argc, &argv);
#endif /*VMS*/
    
    /* Read the preferences file and command line into a database */
    prefDB = CreateNEditPrefDB(&argc, argv);
    localPrefDB = CreateLocalPrefDB(LOCAL_PREF_FILE_NAME, APP_NAME, 
    			LocalOpTable, XtNumber(LocalOpTable), &argc, argv);

    /* Open the display and read X database and remaining command line args */
    
    TheDisplay = XtOpenDisplay (context, NULL, APP_NAME, APP_CLASS, NULL,
    	    0, &argc, argv);

    if (!TheDisplay) {
	XtWarning ("MCflow: Can't open display\n");
	exit(0);
    }

    /* Store preferences from the command line and .mcflow file, 
       and set the appropriate preferences */
    RestoreNEditPrefs(prefDB, XtDatabase(TheDisplay));
    RestoreLocalPrefs(APP_NAME, LocalPrefDescrip, XtNumber(LocalPrefDescrip),
    			localPrefDB, XtDatabase(TheDisplay));
    SetPointerCenteredDialogs(GetPrefRepositionDialogs());
    
/* 
    SavePreferences(TheDisplay, LOCAL_PREF_FILE_NAME, HeaderText,
    	    LocalPrefDescrip, XtNumber(LocalPrefDescrip)); 
 */
    	    
    /* Process any command line arguments (-tags, and files to edit) not
       already processed by RestoreNEditPrefs. */
    fileSpecified = FALSE;
        
    ShowGrepWindow(NULL, NULL, NULL);

    /* Process events. */
    XtAppMainLoop(context);

    return 0;
}
