/*
** 
**  $Header: /usr/home/hellmann/nedit_add_ons/RCS/Aldora.c,v 1.6 96/06/10 09:20:00 hellmann Exp $
** 
**  FILENAME: Aldora.c
** 
**   PURPOSE: Balloon help.
** 
**    AUTHOR: Rajesh Chandran
** 
**    RCSLOG:   $Log:	Aldora.c,v $
** Revision 1.6  96/06/10  09:20:00  hellmann
** Return values from SetValue function
** 
** Revision 1.5  96/02/29  08:58:22  hellmann
** Removed memory leak
** 
** Revision 1.4  96/02/21  17:39:23  hellmann
** Added/updated header.
** 
** 
** 
*/
#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>

#include "AldoraP.h"
#include <Xm/Xm.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>

#include <stdlib.h>

/*
    File    : Aldora.c
    Author  : Rajesh Chandran
    Purpose : Implementation of the popup help system, AldoraHelp
    Version : V0.01E1
    Date    : Mon Feb 13 14:18:26 EST 1995
*/

#define strdup(s) ((char*)strcpy((char*)malloc(strlen(s)+1),s))

typedef struct _AldoraHelpData{
    char *msg;
    Widget w;
} *AldoraHelpData;

#define ALDORA_DEFAULT_DELAY (1500)

static Boolean AldoraHelpActive=True;
static int AldoraHelpDelay=ALDORA_DEFAULT_DELAY;
static XtIntervalId AldoraHelpTimerID=-1;

static Widget AldoraHelpShell;
static Widget AldoraHelpText;

#define offset(field) XtOffsetOf(AldoraHelpRec,field)

static XtResource resources[] = {
    {
        XtNdelay,
	XtCDelay,
	XtRInt,
	sizeof(int),
	offset(aldoraHelp.delay),
	XtRImmediate,
	(XtPointer)ALDORA_DEFAULT_DELAY,
    },
    {
	XtNactive,
	XtCActive,
	XtRBoolean,
	sizeof(Boolean),
	offset(aldoraHelp.active),
	XtRImmediate,
	(XtPointer)True,
    }
};

#undef offset

/* Declaration of methods */

static void Initialize();
static Boolean SetValues();

AldoraHelpClassRec aldoraHelpClassRec = {
    {
    /* superclass         */    (WidgetClass)&rectObjClassRec,
    /* class_name         */    "AldoraHelp",
    /* size               */    sizeof(AldoraHelpRec),
    /* class_initialize   */    NULL,
    /* class_part_initialize*/  NULL,
    /* Class init'ed      */    FALSE,
    /* initialize         */    Initialize,
    /* initialize_hook    */    NULL,
    /* realize            */    NULL,
    /* actions            */    NULL,
    /* num_actions        */    0,
    /* resources          */    resources,
    /* resource_count     */    XtNumber(resources),
    /* xrm_class          */    NULLQUARK,
    /* compress_motion    */    FALSE,
    /* compress_exposure  */    FALSE,
    /* compress_enterleave*/    FALSE,
    /* visible_interest   */    FALSE,
    /* destroy            */    NULL,
    /* resize             */    NULL,
    /* expose             */    NULL,
    /* set_values         */    SetValues,
    /* set_values_hook    */    NULL,
    /* set_values_almost  */    XtInheritSetValuesAlmost,
    /* get_values_hook    */    NULL,
    /* accept_focus       */    NULL,
    /* intrinsics version */    XtVersion,
    /* callback offsets   */    NULL,
    /* tm_table           */    NULL,
    /* query_geometry     */    NULL,
    /* display_accelerator*/    NULL,
    /* extension          */    NULL
    },
    {
    /* dummy_field               */ 0,
    }
};

WidgetClass aldoraHelpObjectClass = (WidgetClass) &aldoraHelpClassRec;

/* ARGSUSED */
static void
Initialize(request,new)
Widget request,new;
{
    AldoraHelpObject obj=(AldoraHelpObject)new;

#ifdef DEBUG_Aldora
	fprintf(stderr,"Aldora: Initialize\n");
#endif

    obj->rectangle.border_width=0;

    if(obj->aldoraHelp.delay<=0){
        fprintf(stderr,"AldoraHelp: Delay must be positive (unchanged).\n");
	return;
    }

#ifdef DEBUG_Aldora
	fprintf(stderr,"Aldora: delay %d\n",obj->aldoraHelp.delay);
#endif

    AldoraHelpDelay=obj->aldoraHelp.delay;
}

/* ARGSUSED */
static Boolean
SetValues(current, request, new, args, num_args)
Widget current, request, new;
ArgList args;
Cardinal *num_args;
{
    AldoraHelpObject obj=(AldoraHelpObject)new;

    if(obj->aldoraHelp.delay<=0){
        fprintf(stderr,"AldoraHelp: Delay must be positive (unchanged).\n");
        obj->aldoraHelp.delay=AldoraHelpDelay;
        return False;
    }

    AldoraHelpDelay=obj->aldoraHelp.delay;
    return True;
}

static void
Destroy(w)
Widget w;
{
}

static void AldoraHelp_DisplayBalloon(AldoraHelpData hlp,
    XtIntervalId *id)
{
    int x,y,xx,yy;
    Dimension h;
    Window dud;
    Widget w=hlp->w;

    XQueryPointer(XtDisplay(w),XtWindow(w),&dud,&dud,
        &x,&y,&xx,&xx,&xx);

    XtVaSetValues(AldoraHelpText,
	XtVaTypedArg,XmNlabelString,XtRString,
	hlp->msg,strlen(hlp->msg)+1,
	NULL);

    XtVaGetValues(AldoraHelpText,
	XmNheight,&h,
	NULL);

    XtVaSetValues(AldoraHelpShell,
        XtNx,x+2,
        XtNy,y-2-h,
        NULL);


    XtPopup(AldoraHelpShell,XtGrabNone);

    AldoraHelpTimerID=-1;
}

static void AldoraHelp_StartTimer(Widget w,XtPointer client_data,
    XEvent *event)
{
    AldoraHelpData hlp=(AldoraHelpData)client_data;

    if(!AldoraHelpActive) return;
    if(AldoraHelpTimerID!=-1){
        XtRemoveTimeOut(AldoraHelpTimerID);
    }

    XtPopdown(AldoraHelpShell);

    AldoraHelpTimerID=XtAppAddTimeOut(XtWidgetToApplicationContext(w),
	AldoraHelpDelay,(XtTimerCallbackProc)AldoraHelp_DisplayBalloon,hlp);

#ifdef DEBUG_Aldora
        fprintf(stderr,"AldoraHelp: Started timer.\n");
#endif
}

static void AldoraHelp_StopTimer(Widget tw,XtPointer client_data,
    XEvent *event)
{
    if(AldoraHelpTimerID!=-1){
        XtRemoveTimeOut(AldoraHelpTimerID);
    }
    XtPopdown(AldoraHelpShell);

#ifdef DEBUG_Aldora
        fprintf(stderr,"Aldora: Removed timer.\n");
#endif
}

static void AldoraHelp_CleanUpMemory(Widget w, XtPointer xtp1, XtPointer xtp2)
{
	AldoraHelpData hlp = (AldoraHelpData) xtp1;
	
	free(hlp->msg);
	free(hlp);
}

Boolean AldoraHelp_Add(Widget w,char *msg)
{
    AldoraHelpData hlp;

    if(!AldoraHelpShell){
/* Create the overrideShell used to popup the messages*/
        Widget frame;

        AldoraHelpShell=XtAppCreateShell(
            "AldoraHelp",
            "AldoraHelp",
            overrideShellWidgetClass,
            XtDisplay(w),
            NULL,
            0);

        XtVaSetValues(AldoraHelpShell,
	    XtNallowShellResize,True,
	    XtNborderWidth,0,
	    NULL);

        frame=XtVaCreateManagedWidget(
            "AldoraHelp",
            xmFrameWidgetClass,
            AldoraHelpShell,
            NULL);

        AldoraHelpText=XtVaCreateManagedWidget(
            "AldoraHelp",
            xmLabelWidgetClass,
            frame,
            NULL);
    }

    hlp=(AldoraHelpData)malloc(sizeof(struct _AldoraHelpData));
    hlp->msg=strdup(msg);
    hlp->w=w;

    XtAddEventHandler(w,EnterWindowMask,False,
        (XtEventHandler)AldoraHelp_StartTimer,hlp);
    XtAddEventHandler(w,LeaveWindowMask,False,
        (XtEventHandler)AldoraHelp_StopTimer,hlp);
    XtAddEventHandler(w,ButtonPressMask,False,
        (XtEventHandler)AldoraHelp_StopTimer,hlp);
    XtAddEventHandler(w,PointerMotionMask,False,
        (XtEventHandler)AldoraHelp_StartTimer,hlp);
    XtAddEventHandler(w,ButtonPressMask,False,
        (XtEventHandler)AldoraHelp_StartTimer,hlp);
    XtAddEventHandler(w,KeyPressMask,False,
        (XtEventHandler)AldoraHelp_StartTimer,hlp);

	XtAddCallback(w, XtNdestroyCallback, AldoraHelp_CleanUpMemory, hlp);

    return True;
}

Boolean AldoraHelp_SetActive(Boolean state)
{
    return AldoraHelpActive=state;    
}

void AldoraHelpOn()
{
  AldoraHelp_SetActive(TRUE);
}

void AldoraHelpOff()
{
  AldoraHelp_SetActive(FALSE);
}
