#ifndef _Aldora_h_
#define _Aldora_h_ 

/*
    File    : Aldora.h
    Author  : Rajesh Chandran
    Purpose : Interface the popup help system, AldoraHelp
    Version : V0.01E1 
    Date    : Mon Feb 13 14:18:26 EST 1995
*/

#include <X11/RectObj.h>

/* the delay between the pointer entering the widget with 
   registered help and the popup of the help text*/
#define XtNdelay "delay"
#define XtCDelay "Delay"

/* the active status  of the help system *NOT USED*
   Use AldoraHelp_SetActive() instead */

#define XtNactive "active"
#define XtCActive "Active"

/* Class record constants */

extern WidgetClass aldoraHelpObjectClass;

typedef struct _AldoraHelpClassRec *AldoraHelpObjectClass;
typedef struct _AldoraHelpRec      *AldoraHelpObject;


/* Public Methods */

Boolean AldoraHelp_Add(Widget w,char *msg);
/* Used to register a widget with AldoraHelp with message
   'msg' */

Boolean AldoraHelp_SetActive(Boolean state);
/* Set active status of the help system */

void RegisterAldoraHelp(XtAppContext app);
void AldoraHelpOn();
void AldoraHelpOff();

#endif
