#ifndef _DEPTREE_P_H
#define _DEPTREE_P_H
/*
 *
 *  HEADER FILE FOR : calltree.c, xcalltre.c
 *
 *  PURPOSE: Define private data structure used from both files.
 *
 *  AUTHOR: Doug Hellmann
 *
 *  DATE: 30 May 1996
 *
 *  COMMENTS: 
 *
*/
#include "list.h" 
#include "deptree.h"

struct Function_struct {
	char 		* name;			/* name of function */
	ObjectFile	* defined_in;		/* object file where defined */
	List 		* used_in;		/* object files where used */
};

struct ObjectFile_struct {
	char		* name;			/* name of object */
	List		* defines;		/* functions we defined */
	List		* externs;		/* functions we use but 
							do not define */
	int		traversed;		/* have we been printed? */
	Package		* package;		/* parent package */
};

struct Package_struct {
	char		* name;			/* name of group of objects */
	List 		* objects;		/* objects related in package */
	List		* uses;			/* packages we use */
	List		* usedby;		/* packages who use us */
	int		traversed;		/* have we been printed? */
	Module		* module;		/* parent module */
	Library		* library;		/* parent library */
	int		consolidated;		
	int		depth;
};

struct Library_struct {
	char		* name;			/* name of group of packages */
	char		* packages;		/* packages logically related */
	List		* uses;			/* libraries we use */
	List		* usedby;		/* libraries who use us */
	int		traversed;		/* have we been printed? */
	Module 		* module;		/* parent module */
};

struct Module_struct {
	char		* name;			/* name of module */
	List 		* packages;		/* packages in this module */
	List		* uses;			/* modules this module uses */
	int		traversed;
};


#endif
