/*
 *
 *  FILENAME: dlgshell.c
 *
 *  COPYRIGHT: 
 *
 *  PURPOSE: Create a generic toplevel dialog shell for use in nedit.
 *
 *  AUTHOR: Doug Hellmann
 *
 *  DATE: 18 September 1995
 *
 *  COMMENTS: 
 *
*/

#include "client.h"
#include "nedit.bm"
#include "file.h"

extern Display *TheDisplay;

/*
 *
 * PURPOSE: Create a dialog shell including attaching the icon.
 *
 * PARAMETERS: Name of the shell widget, window name, icon name, 
 *
 * RETURNS: 
 *
*/
Widget NeditCreateToplevelDialog(
	char * widget_name, 
	char * window_name, 
	char * icon_name)
{
  Widget Return;
  Pixmap iconPixmap = 0, maskPixmap = 0;
  
  Return = XtAppCreateShell(widget_name, "NEdit",
  		applicationShellWidgetClass, TheDisplay, NULL, 0);
  
   /* Add the icon.  There is something weird about the  XmNiconPixmap
     resource that prevents it from being set from the defaults in
     the application resource database.  It's just hardwired here. */
  if (iconPixmap == 0) {
      iconPixmap = XCreatePixmapFromBitmapData( TheDisplay,
                       RootWindowOfScreen(XtScreen (Return)), 
                       (char*)iconBits, iconBitmapWidth, iconBitmapHeight,
                        1, 0, 1);
/* 
      iconPixmap = XCreateBitmapFromData(TheDisplay,
    	      RootWindowOfScreen(XtScreen (Return)), 
	      (char *)iconBits, iconBitmapWidth, iconBitmapHeight);
      maskPixmap = XCreateBitmapFromData(TheDisplay,
    	      RootWindowOfScreen(XtScreen (Return)), 
	      (char *)maskBits, iconBitmapWidth, iconBitmapHeight);
 */
  }
  XtVaSetValues(Return, XmNtitle, window_name,
    			XmNiconName, icon_name,
/* 
    			XmNiconPixmap, iconPixmap,
    			XmNiconMask, maskPixmap,
 */
    			XmNiconPixmap, iconPixmap,
    			NULL);
  
  return Return;

}
